<?php

namespace Drupal\cp_vna_suez_water_service;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\cp_api\MulesoftApiClient;

/**
 * Implements the CpVnaWaterService Service.
 */
class CpVnaWaterService {

  public function __construct(
    protected EntityTypeManagerInterface $entityTypeManager,
    protected ConfigFactoryInterface $configFactory,
    protected MulesoftApiClient $mulesoftApiClient,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public function suezMyAccountGetBuContactNumber($premiseZipcode) {

    if (!$premiseZipcode) {
      return '';
    }

    $arr_storageZipObj = $this->entityTypeManager->getStorage('storage')->loadByProperties(
      [
        'name' => $premiseZipcode,
        'type' => 'zipcode',
      ]);

    $storageZipObj = reset($arr_storageZipObj);

    $contactNumber = '';

    if ($storageZipObj && $storageZipObj->business_unit->target_id) {
      $buGroupObj = $this->entityTypeManager->getStorage('group')->load($storageZipObj->business_unit->target_id);
      if ($buGroupObj && !empty($buGroupObj->field_bu_contact_number->getValue())) {

        foreach ($buGroupObj->field_bu_contact_number->getValue() as $con_num) {
          $contactNumber .= $this->suezMyAccountFormatPhoneNumber($con_num['value']) . ', ';
        }
      }
    }
    else {
      $str_contactNumber = $this->configFactory->get('cp_vna_suez_water_service.settings')->get('contact_number');
      if (!$str_contactNumber) {
        $str_contactNumber = '2017679300';
      }
      $contactNumber = $this->suezMyAccountFormatPhoneNumber($str_contactNumber);
    }

    if (!empty($contactNumber)) {
      $contactNumber = rtrim($contactNumber, ', ');
    }
    return $contactNumber;

  }

  /**
   * Format phone number.
   *
   * {@inheritdoc}
   */
  public function suezMyAccountFormatPhoneNumber($phone_number) {
    if (strlen($phone_number) == 10) {
      $phone_string_1 = sprintf('(%u)', substr($phone_number, 0, 3));
      $phone_string_2 = sprintf(' %u-', substr($phone_number, 0, 3));
      $phone_string_3 = substr($phone_number, -4);
      $phone_number = $phone_string_1 . $phone_string_2 . $phone_string_3;
    }
    return $phone_number;
  }

  /**
   * Address Validate.
   *
   * {@inheritdoc}
   */
  public function suezWsPutAddressValidation($data, $timeout = NULL) {
    $options = [];

    if (!is_null($timeout)) {
      $options['timeout'] = $timeout;
    }

    // Perform validation.
    $allowed_fields = [
      'line1',
      'city',
      'state',
      'zip',
    ];

    if (empty($data['line1'])) {
      throw new \Exception('Invalid address line1.');
    }
    if (empty($data['zip']) || !is_numeric($data['zip']) || strlen($data['zip']) != 5) {
      throw new \Exception('Invalid zip.');
    }

    // If someone sends a field which is not whitelisted above, throw an error.
    $unallowed_fields = array_diff(array_keys($data), $allowed_fields);
    if (count($unallowed_fields) > 0) {
      throw new \Exception('The following fields were not recognized: ' . implode(', ', $unallowed_fields));
    }

    return $this->mulesoftApiClient->checkAddress($data);
  }

}
