(function ($, Drupal) {
  Drupal.behaviors.ourPromise = {
    attach: function (context, settings) {
      if (typeof gsap !== 'undefined') {
        gsap.registerPlugin(ScrollTrigger, SplitText);

        const split = new SplitText(".mainTextWrapper", { type: "words" });

        let tl = gsap.timeline({
          scrollTrigger: {
            trigger: ".mainTextWrapper",
            scrub: 2,
            start: "top 80%",
            end: "bottom center",
          }
        });

        split.words.forEach((word) => {
          tl.to(word, {
            backgroundPositionX: 0,
            ease: "none",
            duration: 1
          });
        });
      }
    }
  };
})(jQuery, Drupal);
