/**
 * @file
 * divihn_bootstrap behaviors.
 */
(function (Drupal, once) {
  'use strict';

  // Debugging
  Drupal.behaviors.divihnBootstrap = {
    attach(context, settings) {
      console.log('It works!');
    }
  };

  // AOS Init (no jQuery needed)
  Drupal.behaviors.aosInit = {
    attach: function (context, settings) {
      if (typeof AOS !== 'undefined') {
        once('aosInit', 'body', context).forEach(() => {
          AOS.init({
            once: true,
            duration: 500,
            easing: 'cubic-bezier(0.745, 0.065, 0.17, 1)',
          });
        });
      }
    }
  };

  // Banner Swiper (no jQuery needed)
  Drupal.behaviors.bannerSwiper = {
    attach: function (context, settings) {
      once('bannerSwiper', '.banner-swiper', context).forEach(function (element) {
        new Swiper(element, {
          loop: true,
          autoplay: {
            delay: 5000,
            disableOnInteraction: false,
          },
          effect: 'slide',
          speed: 700,
          navigation: {
            nextEl: element.querySelector('.banner-navigation .swiper-button-next'),
            prevEl: element.querySelector('.banner-navigation .swiper-button-prev'),
          },
          pagination: {
            el: element.querySelector('.banner-navigation .swiper-pagination'),
            clickable: true,
          },
        });
      });
    }
  };

  // Landing page tab switching
  
})(Drupal, once);

(function ($) {
  $(document).ready(function () {
    // Function to switch tabs
    function switchTab(tab) {
      // Set active class on the clicked tab
      $('.second-fold .tab').removeClass('active');
      $('.second-fold .tab[data-tab="' + tab + '"]').addClass('active');

      // Show only cards for the selected tab in both folds
      $('.tab-card').hide();
      $('.tab-card[data-tab="' + tab + '"]').show();
    }

    // Initialize: show services cards, hide specialisations
    switchTab('services');

    // Tab click event
    $('.second-fold .tab').click(function (e) {
      e.preventDefault();
      var tab = $(this).data('tab');
      switchTab(tab);
    });
  });
})(jQuery);


(function (Drupal, once) {
  'use strict';

  // Arrow scroll for sticky nav tabs
  Drupal.behaviors.scrollableTabs = {
    attach(context, settings) {
      once('scrollable-tabs', '.tab-scroll-wrapper', context).forEach(function (container) {
        const wrapper = container.querySelector('.nav-scroll-wrapper');
        const leftArrow = container.querySelector('.left-arrow');
        const rightArrow = container.querySelector('.right-arrow');

        if (!wrapper || !leftArrow || !rightArrow) return;

        const scrollAmount = 150;

        function updateArrowVisibility() {
          const scrollLeft = wrapper.scrollLeft;
          const maxScrollLeft = wrapper.scrollWidth - wrapper.clientWidth;
          leftArrow.disabled = scrollLeft <= 0;
          rightArrow.disabled = scrollLeft >= maxScrollLeft - 1;
        }

        leftArrow.addEventListener('click', () => {
          wrapper.scrollBy({ left: -scrollAmount, behavior: 'smooth' });
        });

        rightArrow.addEventListener('click', () => {
          wrapper.scrollBy({ left: scrollAmount, behavior: 'smooth' });
        });

        wrapper.addEventListener('scroll', updateArrowVisibility);
        window.addEventListener('resize', updateArrowVisibility);

        updateArrowVisibility(); // Initial call
      });
    }
  };

})(Drupal, once);

