(function ($, Drupal) {
  Drupal.behaviors.divihnSwiper = {
    attach: function (context, settings) {
      once('divihnSwiperInit', '.banner-slide', context).forEach(function (element) {
        new Swiper(element, {
          loop: true,
          autoplay: {
            delay: 5000,
          },
          pagination: {
            el: '.swiper-pagination',
            clickable: true,
          },
          navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
          },
        });
      });
    }
  };
})(jQuery, Drupal);
