routeMatch = $route_match;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('current_route_match')
    );
  }

  /**
   * {@inheritdoc}
   * Adds a configuration form to specify which field name to check.
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['field_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Date field machine name'),
      '#description' => $this->t('Enter the machine name of the date field on the node, e.g., field_webinar_date'),
      '#default_value' => $this->configuration['field_name'] ?? 'field_webinar_date',
      '#required' => TRUE,
    ];
    return parent::buildConfigurationForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    $this->configuration['field_name'] = $form_state->getValue('field_name');
    parent::submitConfigurationForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   * Evaluates the condition.
   */
  public function evaluate() {
    // We expect to be on a node page.
    $node = $this->routeMatch->getParameter('node');
    $field_name = $this->configuration['field_name'] ?? '';

    // Check if we have a node object and a valid field name is configured.
    if (!$node || empty($field_name)) {
      return FALSE;
    }

    // Check if the node has the specific field and if it has a value.
    if ($node->hasField($field_name) && !$node->get($field_name)->isEmpty()) {
      // Get the date value stored in UTC in the database.
      $date_value = $node->get($field_name)->value;
      
      // Create DateTime objects using the storage timezone (UTC).
      $webinar_date = new \DateTime($date_value, new \DateTimeZone(DateTimeItemInterface::STORAGE_TIMEZONE));
      $now = new \DateTime("now", new \DateTimeZone(DateTimeItemInterface::STORAGE_TIMEZONE));

      // The condition is met (returns TRUE) if the webinar date is in the future.
      return $webinar_date > $now;
    }

    return FALSE;
  }

  /**
   * {@inheritdoc}
   * The condition depends on the specific node being viewed and the current time.
   */
  public function getCacheContexts() {
    return ['url.path', 'time'];
  }
}
