/* @license GPL-2.0-or-later https://www.drupal.org/licensing/faq */
(function(Drupal,Swiper){Drupal.behaviors.sliderCollectionSwiper={attach(context){once('swiperInit','.swiper',context).forEach((slider)=>{var options=JSON.parse(slider.getAttribute('data-swiper'));new Swiper(slider,options);});}};}(Drupal,Swiper));;
(function($,Drupal){Drupal.theme.progressBar=function(id){const escapedId=Drupal.checkPlain(id);return (`<div id="${escapedId}" class="progress" aria-live="polite">`+'<div class="progress__label">&nbsp;</div>'+'<div class="progress__track"><div class="progress__bar"></div></div>'+'<div class="progress__percentage"></div>'+'<div class="progress__description">&nbsp;</div>'+'</div>');};Drupal.ProgressBar=function(id,updateCallback,method,errorCallback){this.id=id;this.method=method||'GET';this.updateCallback=updateCallback;this.errorCallback=errorCallback;this.element=$(Drupal.theme('progressBar',id));};$.extend(Drupal.ProgressBar.prototype,{setProgress(percentage,message,label){if(percentage>=0&&percentage<=100){$(this.element).find('div.progress__bar').each(function(){this.style.width=`${percentage}%`;});$(this.element).find('div.progress__percentage').html(`${percentage}%`);}$('div.progress__description',this.element).html(message);$('div.progress__label',this.element).html(label);if(this.updateCallback)this.updateCallback(percentage,message,this);},startMonitoring(uri,delay){this.delay=delay;this.uri=uri;this.sendPing();},stopMonitoring(){clearTimeout(this.timer);this.uri=null;},sendPing(){if(this.timer)clearTimeout(this.timer);if(this.uri){const pb=this;let uri=this.uri;if(!uri.includes('?'))uri+='?';else uri+='&';uri+='_format=json';$.ajax({type:this.method,url:uri,data:'',dataType:'json',success(progress){if(progress.status===0){pb.displayError(progress.data);return;}pb.setProgress(progress.percentage,progress.message,progress.label);pb.timer=setTimeout(()=>{pb.sendPing();},pb.delay);},error(xmlhttp){const e=new Drupal.AjaxError(xmlhttp,pb.uri);pb.displayError(`<pre>${e.message}</pre>`);}});}},displayError(string){const error=$('<div class="messages messages--error"></div>').html(string);$(this.element).before(error).hide();if(this.errorCallback)this.errorCallback(this);}});})(jQuery,Drupal);;
/* @license MIT https://raw.githubusercontent.com/muicss/loadjs/4.3.0/LICENSE.txt */
loadjs=function(){var h=function(){},o={},c={},f={};function u(e,n){if(e){var t=f[e];if(c[e]=n,t)for(;t.length;)t[0](e,n),t.splice(0,1)}}function l(e,n){e.call&&(e={success:e}),n.length?(e.error||h)(n):(e.success||h)(e)}function p(t,r,i,s){var o,e,u,n=document,c=i.async,f=(i.numRetries||0)+1,l=i.before||h,a=t.replace(/[\?|#].*$/,""),d=t.replace(/^(css|img|module|nomodule)!/,"");if(s=s||0,/(^css!|\.css$)/.test(a))(u=n.createElement("link")).rel="stylesheet",u.href=d,(o="hideFocus"in u)&&u.relList&&(o=0,u.rel="preload",u.as="style");else if(/(^img!|\.(png|gif|jpg|svg|webp)$)/.test(a))(u=n.createElement("img")).src=d;else if((u=n.createElement("script")).src=d,u.async=void 0===c||c,e="noModule"in u,/^module!/.test(a)){if(!e)return r(t,"l");u.type="module"}else if(/^nomodule!/.test(a)&&e)return r(t,"l");!(u.onload=u.onerror=u.onbeforeload=function(e){var n=e.type[0];if(o)try{u.sheet.cssText.length||(n="e")}catch(e){18!=e.code&&(n="e")}if("e"==n){if((s+=1)<f)return p(t,r,i,s)}else if("preload"==u.rel&&"style"==u.as)return u.rel="stylesheet";r(t,n,e.defaultPrevented)})!==l(t,u)&&n.head.appendChild(u)}function t(e,n,t){var r,i;if(n&&n.trim&&(r=n),i=(r?t:n)||{},r){if(r in o)throw"LoadJS";o[r]=!0}function s(n,t){!function(e,r,n){var t,i,s=(e=e.push?e:[e]).length,o=s,u=[];for(t=function(e,n,t){if("e"==n&&u.push(e),"b"==n){if(!t)return;u.push(e)}--s||r(u)},i=0;i<o;i++)p(e[i],t,n)}(e,function(e){l(i,e),n&&l({success:n,error:t},e),u(r,e)},i)}if(i.returnPromise)return new Promise(s);s()}return t.ready=function(e,n){return function(e,t){e=e.push?e:[e];var n,r,i,s=[],o=e.length,u=o;for(n=function(e,n){n.length&&s.push(e),--u||t(s)};o--;)r=e[o],(i=c[r])?n(r,i):(f[r]=f[r]||[]).push(n)}(e,function(e){l(n,e)}),t},t.done=function(e){u(e,[])},t.reset=function(){o={},c={},f={}},t.isDefined=function(e){return e in o},t}();;
/* @license GPL-2.0-or-later https://www.drupal.org/licensing/faq */
(function(Drupal,debounce){let liveElement;const announcements=[];Drupal.behaviors.drupalAnnounce={attach(context){if(!liveElement){liveElement=document.createElement('div');liveElement.id='drupal-live-announce';liveElement.className='visually-hidden';liveElement.setAttribute('aria-live','polite');liveElement.setAttribute('aria-busy','false');document.body.appendChild(liveElement);}}};function announce(){const text=[];let priority='polite';let announcement;const il=announcements.length;for(let i=0;i<il;i++){announcement=announcements.pop();text.unshift(announcement.text);if(announcement.priority==='assertive')priority='assertive';}if(text.length){liveElement.innerHTML='';liveElement.setAttribute('aria-busy','true');liveElement.setAttribute('aria-live',priority);liveElement.innerHTML=text.join('\n');liveElement.setAttribute('aria-busy','false');}}Drupal.announce=function(text,priority){announcements.push({text,priority});return debounce(announce,200)();};})(Drupal,Drupal.debounce);;
((Drupal)=>{Drupal.Message=class{constructor(messageWrapper=null){if(!messageWrapper)this.messageWrapper=Drupal.Message.defaultWrapper();else this.messageWrapper=messageWrapper;}static defaultWrapper(){let wrapper=document.querySelector('[data-drupal-messages]')||document.querySelector('[data-drupal-messages-fallback]');if(!wrapper){wrapper=document.createElement('div');document.body.appendChild(wrapper);}if(wrapper.hasAttribute('data-drupal-messages-fallback')){wrapper.removeAttribute('data-drupal-messages-fallback');wrapper.classList.remove('hidden');}wrapper.setAttribute('data-drupal-messages','');return wrapper.innerHTML===''?Drupal.Message.messageInternalWrapper(wrapper):wrapper.firstElementChild;}static getMessageTypeLabels(){return {status:Drupal.t('Status message'),error:Drupal.t('Error message'),warning:Drupal.t('Warning message')};}add(message,options={}){if(!options.hasOwnProperty('type'))options.type='status';if(typeof message!=='string')throw new Error('Message must be a string.');Drupal.Message.announce(message,options);options.id=options.id?String(options.id):`${options.type}-${Math.random().toFixed(15).replace('0.','')}`;if(!Drupal.Message.getMessageTypeLabels().hasOwnProperty(options.type)){const {type}=options;throw new Error(`The message type, ${type}, is not present in Drupal.Message.getMessageTypeLabels().`);}this.messageWrapper.appendChild(Drupal.theme('message',{text:message},options));return options.id;}select(id){return this.messageWrapper.querySelector(`[data-drupal-message-id^="${id}"]`);}remove(id){return this.messageWrapper.removeChild(this.select(id));}clear(){Array.prototype.forEach.call(this.messageWrapper.querySelectorAll('[data-drupal-message-id]'),(message)=>{this.messageWrapper.removeChild(message);});}static announce(message,options){if(!options.priority&&(options.type==='warning'||options.type==='error'))options.priority='assertive';if(options.announce!=='')Drupal.announce(options.announce||message,options.priority);}static messageInternalWrapper(messageWrapper){const innerWrapper=document.createElement('div');innerWrapper.setAttribute('class','messages__wrapper');messageWrapper.insertAdjacentElement('afterbegin',innerWrapper);return innerWrapper;}};Drupal.theme.message=({text},{type,id})=>{const messagesTypes=Drupal.Message.getMessageTypeLabels();const messageWrapper=document.createElement('div');messageWrapper.setAttribute('class',`messages messages--${type}`);messageWrapper.setAttribute('role',type==='error'||type==='warning'?'alert':'status');messageWrapper.setAttribute('data-drupal-message-id',id);messageWrapper.setAttribute('data-drupal-message-type',type);messageWrapper.setAttribute('aria-label',messagesTypes[type]);messageWrapper.innerHTML=`${text}`;return messageWrapper;};})(Drupal);;
((Drupal)=>{Drupal.theme.message=({text},{type,id})=>{const messagesTypes=Drupal.Message.getMessageTypeLabels();const messagesBootstrapTypes={status:'success',warning:'warning',error:'danger',info:'info'};const messageWrapper=document.createElement('div');messageWrapper.setAttribute('class',`messages messages--${type}`);messageWrapper.setAttribute('role',type==='error'||type==='warning'?'alert':'status');messageWrapper.setAttribute('data-drupal-message-id',id);messageWrapper.setAttribute('data-drupal-message-type',type);messageWrapper.innerHTML=`
    <div class="messages__content container alert alert-${messagesBootstrapTypes[type]} alert-dismissible fade show" role="alert">
      <h2 class="visually-hidden">
        ${messagesTypes[type]}
      </h2>
      <span class="messages__item">
        ${text}
      </span>
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
    </div>
  `;return messageWrapper;};})(Drupal);;
(function($,window,Drupal,drupalSettings,loadjs,{isFocusable,tabbable}){Drupal.behaviors.AJAX={attach(context,settings){function loadAjaxBehavior(base){const elementSettings=settings.ajax[base];if(typeof elementSettings.selector==='undefined')elementSettings.selector=`#${base}`;once('drupal-ajax',$(elementSettings.selector)).forEach((el)=>{elementSettings.element=el;elementSettings.base=base;Drupal.ajax(elementSettings);});}Object.keys(settings.ajax||{}).forEach(loadAjaxBehavior);Drupal.ajax.bindAjaxLinks(document.body);once('ajax','.use-ajax-submit').forEach((el)=>{const elementSettings={};elementSettings.url=$(el.form).attr('action');elementSettings.setClick=true;elementSettings.event='click';elementSettings.progress={type:'throbber'};elementSettings.base=el.id;elementSettings.element=el;Drupal.ajax(elementSettings);});},detach(context,settings,trigger){if(trigger==='unload')Drupal.ajax.expired().forEach((instance)=>{Drupal.ajax.instances[instance.instanceIndex]=null;});}};Drupal.AjaxError=function(xmlhttp,uri,customMessage){let statusCode;let statusText;let responseText;if(xmlhttp.status)statusCode=`\n${Drupal.t('An AJAX HTTP error occurred.')}\n${Drupal.t('HTTP Result Code: !status',{'!status':xmlhttp.status})}`;else statusCode=`\n${Drupal.t('An AJAX HTTP request terminated abnormally.')}`;statusCode+=`\n${Drupal.t('Debugging information follows.')}`;const pathText=`\n${Drupal.t('Path: !uri',{'!uri':uri})}`;statusText='';try{statusText=`\n${Drupal.t('StatusText: !statusText',{'!statusText':xmlhttp.statusText.trim()})}`;}catch(e){}responseText='';try{responseText=`\n${Drupal.t('ResponseText: !responseText',{'!responseText':xmlhttp.responseText.trim()})}`;}catch(e){}responseText=responseText.replace(/<("[^"]*"|'[^']*'|[^'">])*>/gi,'');responseText=responseText.replace(/[\n]+\s+/g,'\n');const readyStateText=xmlhttp.status===0?`\n${Drupal.t('ReadyState: !readyState',{'!readyState':xmlhttp.readyState})}`:'';customMessage=customMessage?`\n${Drupal.t('CustomMessage: !customMessage',{'!customMessage':customMessage})}`:'';this.message=statusCode+pathText+statusText+customMessage+responseText+readyStateText;this.name='AjaxError';if(!Drupal.AjaxError.messages)Drupal.AjaxError.messages=new Drupal.Message();Drupal.AjaxError.messages.add(Drupal.t("Oops, something went wrong. Check your browser's developer console for more details."),{type:'error'});};Drupal.AjaxError.prototype=new Error();Drupal.AjaxError.prototype.constructor=Drupal.AjaxError;Drupal.ajax=function(settings){if(arguments.length!==1)throw new Error('Drupal.ajax() function must be called with one configuration object only');const base=settings.base||false;const element=settings.element||false;delete settings.base;delete settings.element;if(!settings.progress&&!element)settings.progress=false;const ajax=new Drupal.Ajax(base,element,settings);ajax.instanceIndex=Drupal.ajax.instances.length;Drupal.ajax.instances.push(ajax);return ajax;};Drupal.ajax.instances=[];Drupal.ajax.expired=function(){return Drupal.ajax.instances.filter((instance)=>instance&&instance.element!==false&&!document.body.contains(instance.element));};Drupal.ajax.bindAjaxLinks=(element)=>{once('ajax','.use-ajax',element).forEach((ajaxLink)=>{const $linkElement=$(ajaxLink);const elementSettings={progress:{type:'throbber'},dialogType:$linkElement.data('dialog-type'),dialog:$linkElement.data('dialog-options'),dialogRenderer:$linkElement.data('dialog-renderer'),base:$linkElement.attr('id'),element:ajaxLink};const href=$linkElement.attr('href');if(href){elementSettings.url=href;elementSettings.event='click';}const httpMethod=$linkElement.data('ajax-http-method');if(httpMethod)elementSettings.httpMethod=httpMethod;Drupal.ajax(elementSettings);});};Drupal.Ajax=function(base,element,elementSettings){const defaults={httpMethod:'POST',event:element?'mousedown':null,keypress:true,selector:base?`#${base}`:null,effect:'none',speed:'none',method:'replaceWith',progress:{type:'throbber',message:Drupal.t('Processing...')},submit:{js:true}};$.extend(this,defaults,elementSettings);this.commands=new Drupal.AjaxCommands();this.instanceIndex=false;if(this.wrapper)this.wrapper=`#${this.wrapper}`;this.element=element;this.preCommandsFocusedElementSelector=null;this.elementSettings=elementSettings;if(this.element&&this.element.form)this.$form=$(this.element.form);if(!this.url){const $element=$(this.element);if(this.element.tagName==='A')this.url=$element.attr('href');else{if(this.element&&element.form)this.url=this.$form.attr('action');}}const originalUrl=this.url;this.url=this.url.replace(/\/nojs(\/|$|\?|#)/,'/ajax$1');if(drupalSettings.ajaxTrustedUrl[originalUrl])drupalSettings.ajaxTrustedUrl[this.url]=true;const ajax=this;ajax.options={url:ajax.url,data:ajax.submit,isInProgress(){return ajax.ajaxing;},beforeSerialize(elementSettings,options){return ajax.beforeSerialize(elementSettings,options);},beforeSubmit(formValues,elementSettings,options){ajax.ajaxing=true;ajax.preCommandsFocusedElementSelector=null;return ajax.beforeSubmit(formValues,elementSettings,options);},beforeSend(xmlhttprequest,options){ajax.ajaxing=true;return ajax.beforeSend(xmlhttprequest,options);},success(response,status,xmlhttprequest){ajax.preCommandsFocusedElementSelector=document.activeElement.getAttribute('data-drupal-selector');if(typeof response==='string')response=$.parseJSON(response);if(response!==null&&!drupalSettings.ajaxTrustedUrl[ajax.url])if(xmlhttprequest.getResponseHeader('X-Drupal-Ajax-Token')!=='1'){const customMessage=Drupal.t('The response failed verification so will not be processed.');return ajax.error(xmlhttprequest,ajax.url,customMessage);}return (Promise.resolve(ajax.success(response,status)).then(()=>{ajax.ajaxing=false;$(document).trigger('ajaxSuccess',[xmlhttprequest,this]);$(document).trigger('ajaxComplete',[xmlhttprequest,this]);if(--$.active===0)$(document).trigger('ajaxStop');}));},error(xmlhttprequest,status,error){ajax.ajaxing=false;},complete(xmlhttprequest,status){if(status==='error'||status==='parsererror')return ajax.error(xmlhttprequest,ajax.url);},dataType:'json',jsonp:false,method:ajax.httpMethod};if(elementSettings.dialog)ajax.options.data.dialogOptions=elementSettings.dialog;if(!ajax.options.url.includes('?'))ajax.options.url+='?';else ajax.options.url+='&';let wrapper=`drupal_${elementSettings.dialogType||'ajax'}`;if(elementSettings.dialogRenderer)wrapper+=`.${elementSettings.dialogRenderer}`;ajax.options.url+=`${Drupal.ajax.WRAPPER_FORMAT}=${wrapper}`;$(ajax.element).on(elementSettings.event,function(event){if(!drupalSettings.ajaxTrustedUrl[ajax.url]&&!Drupal.url.isLocal(ajax.url))throw new Error(Drupal.t('The callback URL is not local and not trusted: !url',{'!url':ajax.url}));return ajax.eventResponse(this,event);});if(elementSettings.keypress)$(ajax.element).on('keypress',function(event){return ajax.keypressResponse(this,event);});if(elementSettings.prevent)$(ajax.element).on(elementSettings.prevent,false);};Drupal.ajax.WRAPPER_FORMAT='_wrapper_format';Drupal.Ajax.AJAX_REQUEST_PARAMETER='_drupal_ajax';Drupal.Ajax.prototype.execute=function(){if(this.ajaxing)return;try{this.beforeSerialize(this.element,this.options);return $.ajax(this.options);}catch(e){this.ajaxing=false;window.alert(`An error occurred while attempting to process ${this.options.url}: ${e.message}`);return $.Deferred().reject();}};Drupal.Ajax.prototype.keypressResponse=function(element,event){const ajax=this;if(event.which===13||(event.which===32&&element.type!=='text'&&element.type!=='textarea'&&element.type!=='tel'&&element.type!=='number')){event.preventDefault();event.stopPropagation();$(element).trigger(ajax.elementSettings.event);}};Drupal.Ajax.prototype.eventResponse=function(element,event){event.preventDefault();event.stopPropagation();const ajax=this;if(ajax.ajaxing)return;try{if(ajax.$form){if(ajax.setClick)element.form.clk=element;ajax.$form.ajaxSubmit(ajax.options);}else{ajax.beforeSerialize(ajax.element,ajax.options);$.ajax(ajax.options);}}catch(e){ajax.ajaxing=false;window.alert(`An error occurred while attempting to process ${ajax.options.url}: ${e.message}`);}};Drupal.Ajax.prototype.beforeSerialize=function(element,options){if(this.$form&&document.body.contains(this.$form.get(0))){const settings=this.settings||drupalSettings;Drupal.detachBehaviors(this.$form.get(0),settings,'serialize');}options.data[Drupal.Ajax.AJAX_REQUEST_PARAMETER]=1;const pageState=drupalSettings.ajaxPageState;options.data['ajax_page_state[theme]']=pageState.theme;options.data['ajax_page_state[theme_token]']=pageState.theme_token;options.data['ajax_page_state[libraries]']=pageState.libraries;};Drupal.Ajax.prototype.beforeSubmit=function(formValues,element,options){};Drupal.Ajax.prototype.beforeSend=function(xmlhttprequest,options){if(this.$form){options.extraData=options.extraData||{};options.extraData.ajax_iframe_upload='1';const v=$.fieldValue(this.element);if(v!==null)options.extraData[this.element.name]=v;}$(this.element).prop('disabled',true);if(!this.progress||!this.progress.type)return;const progressIndicatorMethod=`setProgressIndicator${this.progress.type.slice(0,1).toUpperCase()}${this.progress.type.slice(1).toLowerCase()}`;if(progressIndicatorMethod in this&&typeof this[progressIndicatorMethod]==='function')this[progressIndicatorMethod].call(this);};Drupal.theme.ajaxProgressThrobber=(message)=>{const messageMarkup=typeof message==='string'?Drupal.theme('ajaxProgressMessage',message):'';const throbber='<div class="throbber">&nbsp;</div>';return `<div class="ajax-progress ajax-progress-throbber">${throbber}${messageMarkup}</div>`;};Drupal.theme.ajaxProgressIndicatorFullscreen=()=>'<div class="ajax-progress ajax-progress-fullscreen">&nbsp;</div>';Drupal.theme.ajaxProgressMessage=(message)=>`<div class="message">${message}</div>`;Drupal.theme.ajaxProgressBar=($element)=>$('<div class="ajax-progress ajax-progress-bar"></div>').append($element);Drupal.Ajax.prototype.setProgressIndicatorBar=function(){const progressBar=new Drupal.ProgressBar(`ajax-progress-${this.element.id}`,$.noop,this.progress.method,$.noop);if(this.progress.message)progressBar.setProgress(-1,this.progress.message);if(this.progress.url)progressBar.startMonitoring(this.progress.url,this.progress.interval||1500);this.progress.element=$(Drupal.theme('ajaxProgressBar',progressBar.element));this.progress.object=progressBar;$(this.element).after(this.progress.element);};Drupal.Ajax.prototype.setProgressIndicatorThrobber=function(){this.progress.element=$(Drupal.theme('ajaxProgressThrobber',this.progress.message));if($(this.element).closest('[data-drupal-ajax-container]').length)$(this.element).closest('[data-drupal-ajax-container]').after(this.progress.element);else $(this.element).after(this.progress.element);};Drupal.Ajax.prototype.setProgressIndicatorFullscreen=function(){this.progress.element=$(Drupal.theme('ajaxProgressIndicatorFullscreen'));$('body').append(this.progress.element);};Drupal.Ajax.prototype.commandExecutionQueue=function(response,status){const ajaxCommands=this.commands;return Object.keys(response||{}).reduce((executionQueue,key)=>executionQueue.then(()=>{const {command}=response[key];if(command&&ajaxCommands[command])return ajaxCommands[command](this,response[key],status);}),Promise.resolve());};Drupal.Ajax.prototype.success=function(response,status){if(this.progress.element)$(this.progress.element).remove();if(this.progress.object)this.progress.object.stopMonitoring();$(this.element).prop('disabled',false);const elementParents=$(this.element).parents('[data-drupal-selector]').addBack().toArray();const focusChanged=Object.keys(response||{}).some((key)=>{const {command,method}=response[key];return (command==='focusFirst'||command==='openDialog'||(command==='invoke'&&method==='focus'));});return (this.commandExecutionQueue(response,status).then(()=>{if(!focusChanged){let target=false;if(this.element){if($(this.element).data('refocus-blur')&&this.preCommandsFocusedElementSelector)target=document.querySelector(`[data-drupal-selector="${this.preCommandsFocusedElementSelector}"]`);if(!target&&!$(this.element).data('disable-refocus')){for(let n=elementParents.length-1;!target&&n>=0;n--)target=document.querySelector(`[data-drupal-selector="${elementParents[n].getAttribute('data-drupal-selector')}"]`);}}if(target)$(target).trigger('focus');}if(this.$form&&document.body.contains(this.$form.get(0))){const settings=this.settings||drupalSettings;Drupal.attachBehaviors(this.$form.get(0),settings);}this.settings=null;}).catch((error)=>console.error(Drupal.t('An error occurred during the execution of the Ajax response: !error',{'!error':error}))));};Drupal.Ajax.prototype.getEffect=function(response){const type=response.effect||this.effect;const speed=response.speed||this.speed;const effect={};if(type==='none'){effect.showEffect='show';effect.hideEffect='hide';effect.showSpeed='';}else if(type==='fade'){effect.showEffect='fadeIn';effect.hideEffect='fadeOut';effect.showSpeed=speed;}else{effect.showEffect=`${type}Toggle`;effect.hideEffect=`${type}Toggle`;effect.showSpeed=speed;}return effect;};Drupal.Ajax.prototype.error=function(xmlhttprequest,uri,customMessage){if(this.progress.element)$(this.progress.element).remove();if(this.progress.object)this.progress.object.stopMonitoring();$(this.wrapper).show();$(this.element).prop('disabled',false);if(this.$form&&document.body.contains(this.$form.get(0))){const settings=this.settings||drupalSettings;Drupal.attachBehaviors(this.$form.get(0),settings);}throw new Drupal.AjaxError(xmlhttprequest,uri,customMessage);};Drupal.theme.ajaxWrapperNewContent=($newContent,ajax,response)=>(response.effect||ajax.effect)!=='none'&&$newContent.filter((i)=>!(($newContent[i].nodeName==='#comment'||($newContent[i].nodeName==='#text'&&/^(\s|\n|\r)*$/.test($newContent[i].textContent))))).length>1?Drupal.theme('ajaxWrapperMultipleRootElements',$newContent):$newContent;Drupal.theme.ajaxWrapperMultipleRootElements=($elements)=>$('<div></div>').append($elements);Drupal.AjaxCommands=function(){};Drupal.AjaxCommands.prototype={insert(ajax,response){const $wrapper=response.selector?$(response.selector):$(ajax.wrapper);const method=response.method||ajax.method;const effect=ajax.getEffect(response);const settings=response.settings||ajax.settings||drupalSettings;const parseHTML=(htmlString)=>{const fragment=document.createDocumentFragment();const tempDiv=fragment.appendChild(document.createElement('div'));tempDiv.innerHTML=htmlString;return tempDiv.childNodes;};let $newContent=$(parseHTML(response.data));$newContent=Drupal.theme('ajaxWrapperNewContent',$newContent,ajax,response);switch(method){case 'html':case 'replaceWith':case 'replaceAll':case 'empty':case 'remove':Drupal.detachBehaviors($wrapper.get(0),settings);break;default:break;}$wrapper[method]($newContent);if(effect.showEffect!=='show')$newContent.hide();const $ajaxNewContent=$newContent.find('.ajax-new-content');if($ajaxNewContent.length){$ajaxNewContent.hide();$newContent.show();$ajaxNewContent[effect.showEffect](effect.showSpeed);}else{if(effect.showEffect!=='show')$newContent[effect.showEffect](effect.showSpeed);}$newContent.each((index,element)=>{if(element.nodeType===Node.ELEMENT_NODE&&document.documentElement.contains(element))Drupal.attachBehaviors(element,settings);});},remove(ajax,response,status){const settings=response.settings||ajax.settings||drupalSettings;$(response.selector).each(function(){Drupal.detachBehaviors(this,settings);}).remove();},changed(ajax,response,status){const $element=$(response.selector);if(!$element.hasClass('ajax-changed')){$element.addClass('ajax-changed');if(response.asterisk)$element.find(response.asterisk).append(` <abbr class="ajax-changed" title="${Drupal.t('Changed')}">*</abbr> `);}},alert(ajax,response,status){window.alert(response.text);},announce(ajax,response){if(response.priority)Drupal.announce(response.text,response.priority);else Drupal.announce(response.text);},redirect(ajax,response,status){window.location=response.url;},css(ajax,response,status){$(response.selector).css(response.argument);},settings(ajax,response,status){const ajaxSettings=drupalSettings.ajax;if(ajaxSettings)Drupal.ajax.expired().forEach((instance)=>{if(instance.selector){const selector=instance.selector.replace('#','');if(selector in ajaxSettings)delete ajaxSettings[selector];}});if(response.merge)$.extend(true,drupalSettings,response.settings);else ajax.settings=response.settings;},data(ajax,response,status){$(response.selector).data(response.name,response.value);},focusFirst(ajax,response,status){let focusChanged=false;const container=document.querySelector(response.selector);if(container){const tabbableElements=tabbable(container);if(tabbableElements.length){tabbableElements[0].focus();focusChanged=true;}else{if(isFocusable(container)){container.focus();focusChanged=true;}}}if(ajax.hasOwnProperty('element')&&!focusChanged)ajax.element.focus();},invoke(ajax,response,status){const $element=$(response.selector);$element[response.method](...response.args);},restripe(ajax,response,status){$(response.selector).find('> tbody > tr:visible, > tr:visible').removeClass('odd even').filter(':even').addClass('odd').end().filter(':odd').addClass('even');},update_build_id(ajax,response,status){document.querySelectorAll(`input[name="form_build_id"][value="${response.old}"]`).forEach((item)=>{item.value=response.new;});},add_css(ajax,response,status){if(typeof response.data==='string'){Drupal.deprecationError({message:'Passing a string to the Drupal.ajax.add_css() method is deprecated in 10.1.0 and is removed from drupal:11.0.0. See https://www.drupal.org/node/3154948.'});$('head').prepend(response.data);return;}const allUniqueBundleIds=response.data.map(function(style){const uniqueBundleId=style.href;if(!loadjs.isDefined(uniqueBundleId))loadjs(`css!${style.href}`,uniqueBundleId,{before(path,styleEl){Object.keys(style).forEach((attributeKey)=>{styleEl.setAttribute(attributeKey,style[attributeKey]);});}});return uniqueBundleId;});return new Promise((resolve,reject)=>{loadjs.ready(allUniqueBundleIds,{success(){resolve();},error(depsNotFound){const message=Drupal.t(`The following files could not be loaded: @dependencies`,{'@dependencies':depsNotFound.join(', ')});reject(message);}});});},message(ajax,response){const messages=new Drupal.Message(document.querySelector(response.messageWrapperQuerySelector));if(response.clearPrevious)messages.clear();messages.add(response.message,response.messageOptions);},add_js(ajax,response,status){const parentEl=document.querySelector(response.selector||'body');const settings=ajax.settings||drupalSettings;const allUniqueBundleIds=response.data.map((script)=>{const uniqueBundleId=script.src;if(!loadjs.isDefined(uniqueBundleId))loadjs(script.src,uniqueBundleId,{async:false,before(path,scriptEl){Object.keys(script).forEach((attributeKey)=>{scriptEl.setAttribute(attributeKey,script[attributeKey]);});parentEl.appendChild(scriptEl);return false;}});return uniqueBundleId;});return new Promise((resolve,reject)=>{loadjs.ready(allUniqueBundleIds,{success(){Drupal.attachBehaviors(parentEl,settings);resolve();},error(depsNotFound){const message=Drupal.t(`The following files could not be loaded: @dependencies`,{'@dependencies':depsNotFound.join(', ')});reject(message);}});});},scrollTop(ajax,response){const offset=$(response.selector).offset();let scrollTarget=response.selector;while($(scrollTarget).scrollTop()===0&&$(scrollTarget).parent())scrollTarget=$(scrollTarget).parent();if(offset.top-10<$(scrollTarget).scrollTop())scrollTarget.get(0).scrollTo({top:offset.top-10,behavior:'smooth'});}};const stopEvent=(xhr,settings)=>{return (xhr.getResponseHeader('X-Drupal-Ajax-Token')==='1'&&settings.isInProgress&&settings.isInProgress());};$.extend(true,$.event.special,{ajaxSuccess:{trigger(event,xhr,settings){if(stopEvent(xhr,settings))return false;}},ajaxComplete:{trigger(event,xhr,settings){if(stopEvent(xhr,settings)){$.active++;return false;}}}});})(jQuery,window,Drupal,drupalSettings,loadjs,window.tabbable);;
(($,Drupal,{isTabbable})=>{$.extend($.expr[':'],{tabbable(element){Drupal.deprecationError({message:'The :tabbable selector is deprecated in Drupal 9.2.0 and will be removed in Drupal 11.0.0. Use the core/tabbable library instead. See https://www.drupal.org/node/3183730'});return isTabbable(element);}});})(jQuery,Drupal,window.tabbable);;
(($)=>{let cachedScrollbarWidth=null;const {max,abs}=Math;const regexHorizontal=/left|center|right/;const regexVertical=/top|center|bottom/;const regexOffset=/[+-]\d+(\.[\d]+)?%?/;const regexPosition=/^\w+/;const _position=$.fn.position;function getOffsets(offsets,width,height){return [parseFloat(offsets[0])*(typeof offsets[0]==='string'&&offsets[0].endsWith('%')?width/100:1),parseFloat(offsets[1])*(typeof offsets[1]==='string'&&offsets[1].endsWith('%')?height/100:1)];}function parseCss(element,property){return parseInt(window.getComputedStyle(element)[property],10)||0;}function getDimensions(elem){const raw=elem[0];if(raw.nodeType===9)return {width:elem.width(),height:elem.height(),offset:{top:0,left:0}};if(!!raw&&raw===raw.window)return {width:elem.width(),height:elem.height(),offset:{top:elem.scrollTop(),left:elem.scrollLeft()}};if(raw.preventDefault)return {width:0,height:0,offset:{top:raw.pageY,left:raw.pageX}};return {width:elem.outerWidth(),height:elem.outerHeight(),offset:elem.offset()};}const collisions={fit:{left(position,data){const {within}=data;const withinOffset=within.isWindow?within.scrollLeft:within.offset.left;const outerWidth=within.width;const collisionPosLeft=position.left-data.collisionPosition.marginLeft;const overLeft=withinOffset-collisionPosLeft;const overRight=collisionPosLeft+data.collisionWidth-outerWidth-withinOffset;let newOverRight;if(data.collisionWidth>outerWidth)if(overLeft>0&&overRight<=0){newOverRight=position.left+overLeft+data.collisionWidth-outerWidth-withinOffset;position.left+=overLeft-newOverRight;}else if(overRight>0&&overLeft<=0)position.left=withinOffset;else if(overLeft>overRight)position.left=withinOffset+outerWidth-data.collisionWidth;else position.left=withinOffset;else if(overLeft>0)position.left+=overLeft;else if(overRight>0)position.left-=overRight;else position.left=max(position.left-collisionPosLeft,position.left);},top(position,data){const {within}=data;const withinOffset=within.isWindow?within.scrollTop:within.offset.top;const outerHeight=data.within.height;const collisionPosTop=position.top-data.collisionPosition.marginTop;const overTop=withinOffset-collisionPosTop;const overBottom=collisionPosTop+data.collisionHeight-outerHeight-withinOffset;let newOverBottom;if(data.collisionHeight>outerHeight)if(overTop>0&&overBottom<=0){newOverBottom=position.top+overTop+data.collisionHeight-outerHeight-withinOffset;position.top+=overTop-newOverBottom;}else if(overBottom>0&&overTop<=0)position.top=withinOffset;else if(overTop>overBottom)position.top=withinOffset+outerHeight-data.collisionHeight;else position.top=withinOffset;else if(overTop>0)position.top+=overTop;else if(overBottom>0)position.top-=overBottom;else position.top=max(position.top-collisionPosTop,position.top);}},flip:{left(position,data){const {within}=data;const withinOffset=within.offset.left+within.scrollLeft;const outerWidth=within.width;const offsetLeft=within.isWindow?within.scrollLeft:within.offset.left;const collisionPosLeft=position.left-data.collisionPosition.marginLeft;const overLeft=collisionPosLeft-offsetLeft;const overRight=collisionPosLeft+data.collisionWidth-outerWidth-offsetLeft;const myOffset=data.my[0]==='left'?-data.elemWidth:data.my[0]==='right'?data.elemWidth:0;const atOffset=data.at[0]==='left'?data.targetWidth:data.at[0]==='right'?-data.targetWidth:0;const offset=-2*data.offset[0];let newOverRight;let newOverLeft;if(overLeft<0){newOverRight=position.left+myOffset+atOffset+offset+data.collisionWidth-outerWidth-withinOffset;if(newOverRight<0||newOverRight<abs(overLeft))position.left+=myOffset+atOffset+offset;}else{if(overRight>0){newOverLeft=position.left-data.collisionPosition.marginLeft+myOffset+atOffset+offset-offsetLeft;if(newOverLeft>0||abs(newOverLeft)<overRight)position.left+=myOffset+atOffset+offset;}}},top(position,data){const {within}=data;const withinOffset=within.offset.top+within.scrollTop;const outerHeight=within.height;const offsetTop=within.isWindow?within.scrollTop:within.offset.top;const collisionPosTop=position.top-data.collisionPosition.marginTop;const overTop=collisionPosTop-offsetTop;const overBottom=collisionPosTop+data.collisionHeight-outerHeight-offsetTop;const top=data.my[1]==='top';const myOffset=top?-data.elemHeight:data.my[1]==='bottom'?data.elemHeight:0;const atOffset=data.at[1]==='top'?data.targetHeight:data.at[1]==='bottom'?-data.targetHeight:0;const offset=-2*data.offset[1];let newOverTop;let newOverBottom;if(overTop<0){newOverBottom=position.top+myOffset+atOffset+offset+data.collisionHeight-outerHeight-withinOffset;if(newOverBottom<0||newOverBottom<abs(overTop))position.top+=myOffset+atOffset+offset;}else{if(overBottom>0){newOverTop=position.top-data.collisionPosition.marginTop+myOffset+atOffset+offset-offsetTop;if(newOverTop>0||abs(newOverTop)<overBottom)position.top+=myOffset+atOffset+offset;}}}},flipfit:{left(...args){collisions.flip.left.apply(this,args);collisions.fit.left.apply(this,args);},top(...args){collisions.flip.top.apply(this,args);collisions.fit.top.apply(this,args);}}};$.position={scrollbarWidth(){if(cachedScrollbarWidth!==undefined)return cachedScrollbarWidth;const div=$('<div '+"style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'>"+"<div style='height:100px;width:auto;'></div></div>");const innerDiv=div.children()[0];$('body').append(div);const w1=innerDiv.offsetWidth;div[0].style.overflow='scroll';let w2=innerDiv.offsetWidth;if(w1===w2)w2=div[0].clientWidth;div.remove();cachedScrollbarWidth=w1-w2;return cachedScrollbarWidth;},getScrollInfo(within){const overflowX=within.isWindow||within.isDocument?'':window.getComputedStyle(within.element[0])['overflow-x'];const overflowY=within.isWindow||within.isDocument?'':window.getComputedStyle(within.element[0])['overflow-y'];const hasOverflowX=overflowX==='scroll'||(overflowX==='auto'&&within.width<within.element[0].scrollWidth);const hasOverflowY=overflowY==='scroll'||(overflowY==='auto'&&within.height<within.element[0].scrollHeight);return {width:hasOverflowY?$.position.scrollbarWidth():0,height:hasOverflowX?$.position.scrollbarWidth():0};},getWithinInfo(element){const withinElement=$(element||window);const isWindow=!!withinElement[0]&&withinElement[0]===withinElement[0].window;const isDocument=!!withinElement[0]&&withinElement[0].nodeType===9;const hasOffset=!isWindow&&!isDocument;return {element:withinElement,isWindow,isDocument,offset:hasOffset?$(element).offset():{left:0,top:0},scrollLeft:withinElement.scrollLeft(),scrollTop:withinElement.scrollTop(),width:withinElement.outerWidth(),height:withinElement.outerHeight()};}};$.fn.position=function(options){if(!options||!options.of)return _position.apply(this,arguments);options=$.extend({},options);const within=$.position.getWithinInfo(options.within);const scrollInfo=$.position.getScrollInfo(within);const collision=(options.collision||'flip').split(' ');const offsets={};const target=typeof options.of==='string'?$(document).find(options.of):$(options.of);const dimensions=getDimensions(target);const targetWidth=dimensions.width;const targetHeight=dimensions.height;const targetOffset=dimensions.offset;if(target[0].preventDefault)options.at='left top';const basePosition=$.extend({},targetOffset);$.each(['my','at'],function(){let pos=(options[this]||'').split(' ');if(pos.length===1)pos=regexHorizontal.test(pos[0])?pos.concat(['center']):regexVertical.test(pos[0])?['center'].concat(pos):['center','center'];pos[0]=regexHorizontal.test(pos[0])?pos[0]:'center';pos[1]=regexVertical.test(pos[1])?pos[1]:'center';const horizontalOffset=regexOffset.exec(pos[0]);const verticalOffset=regexOffset.exec(pos[1]);offsets[this]=[horizontalOffset?horizontalOffset[0]:0,verticalOffset?verticalOffset[0]:0];options[this]=[regexPosition.exec(pos[0])[0],regexPosition.exec(pos[1])[0]];});if(collision.length===1)collision[1]=collision[0];if(options.at[0]==='right')basePosition.left+=targetWidth;else{if(options.at[0]==='center')basePosition.left+=targetWidth/2;}if(options.at[1]==='bottom')basePosition.top+=targetHeight;else{if(options.at[1]==='center')basePosition.top+=targetHeight/2;}const atOffset=getOffsets(offsets.at,targetWidth,targetHeight);basePosition.left+=atOffset[0];basePosition.top+=atOffset[1];return this.each(function(){let using;const elem=$(this);const elemWidth=elem.outerWidth();const elemHeight=elem.outerHeight();const marginLeft=parseCss(this,'marginLeft');const marginTop=parseCss(this,'marginTop');const collisionWidth=elemWidth+marginLeft+parseCss(this,'marginRight')+scrollInfo.width;const collisionHeight=elemHeight+marginTop+parseCss(this,'marginBottom')+scrollInfo.height;const position=$.extend({},basePosition);const myOffset=getOffsets(offsets.my,elem.outerWidth(),elem.outerHeight());if(options.my[0]==='right')position.left-=elemWidth;else{if(options.my[0]==='center')position.left-=elemWidth/2;}if(options.my[1]==='bottom')position.top-=elemHeight;else{if(options.my[1]==='center')position.top-=elemHeight/2;}position.left+=myOffset[0];position.top+=myOffset[1];const collisionPosition={marginLeft,marginTop};$.each(['left','top'],function(i,dir){if(collisions[collision[i]])collisions[collision[i]][dir](position,{targetWidth,targetHeight,elemWidth,elemHeight,collisionPosition,collisionWidth,collisionHeight,offset:[atOffset[0]+myOffset[0],atOffset[1]+myOffset[1]],my:options.my,at:options.at,within,elem});});if(options.using)using=function(props){const left=targetOffset.left-position.left;const right=left+targetWidth-elemWidth;const top=targetOffset.top-position.top;const bottom=top+targetHeight-elemHeight;const feedback={target:{element:target,left:targetOffset.left,top:targetOffset.top,width:targetWidth,height:targetHeight},element:{element:elem,left:position.left,top:position.top,width:elemWidth,height:elemHeight},horizontal:right<0?'left':left>0?'right':'center',vertical:bottom<0?'top':top>0?'bottom':'middle'};if(targetWidth<elemWidth&&abs(left+right)<targetWidth)feedback.horizontal='center';if(targetHeight<elemHeight&&abs(top+bottom)<targetHeight)feedback.vertical='middle';if(max(abs(left),abs(right))>max(abs(top),abs(bottom)))feedback.important='horizontal';else feedback.important='vertical';options.using.call(this,props,feedback);};elem.offset($.extend(position,{using}));});};if(!$.hasOwnProperty('ui'))$.ui={};$.ui.position=collisions;})(jQuery);;
(($,Drupal,drupalSettings,once)=>{if(!Drupal.autocomplete)return;const autocomplete={};autocomplete.getSettings=(input,globalSettings)=>{globalSettings=globalSettings||drupalSettings||{};const settings={auto_submit:false,delay:0,min_length:1,selector:':submit'};const search=$(input).data('search-api-autocomplete-search');if(search&&globalSettings.search_api_autocomplete&&globalSettings.search_api_autocomplete[search])$.extend(settings,globalSettings.search_api_autocomplete[search]);return settings;};Drupal.behaviors.searchApiAutocomplete={attach(context,settings){const s='.ui-autocomplete-input[data-search-api-autocomplete-search]';$(once('search-api-autocomplete',s,context)).each(function foreach(){const uiAutocomplete=$(this).data('ui-autocomplete');if(!uiAutocomplete)return;const $element=uiAutocomplete.menu.element;$element.data('search-api-autocomplete-input-id',this.id);$element.addClass('search-api-autocomplete-search');$element.attr('tabindex','-1');const elementSettings=autocomplete.getSettings(this,settings);if(elementSettings.delay)uiAutocomplete.options.delay=elementSettings.delay;if(elementSettings.min_length)uiAutocomplete.options.minLength=elementSettings.min_length;const oldSelect=uiAutocomplete.options.select;uiAutocomplete.options.select=function select(event,ui,...args){if(ui.item.url){if(event.keyCode===9)return false;window.location.href=ui.item.url;return false;}const ret=oldSelect.apply(this,[event,ui,...args]);if(elementSettings.auto_submit&&elementSettings.selector)$(elementSettings.selector,this.form).trigger('click');return ret;};});}};Drupal.SearchApiAutocomplete=autocomplete;})(jQuery,Drupal,drupalSettings,once);;
(function($,Drupal,drupalSettings,once){"use strict";Drupal.TBMegaMenu=Drupal.TBMegaMenu||{};Drupal.TBMegaMenu.oldWindowWidth=0;Drupal.TBMegaMenu.displayedMenuMobile=false;Drupal.TBMegaMenu.supportedScreens=[980];Drupal.TBMegaMenu.focusableElements='a:not([disabled]), button:not([disabled]), input:not([disabled]), select:not([disabled]), textarea:not([disabled]), details:not([disabled]), [tabindex]:not([disabled]):not([tabindex="-1"])';Drupal.TBMegaMenu.menuResponsive=function(){var windowWidth=window.innerWidth?window.innerWidth:$(window).width();var navCollapse=$('.tb-megamenu').children('.nav-collapse');if(windowWidth<Drupal.TBMegaMenu.supportedScreens[0]){navCollapse.addClass('collapse');if(Drupal.TBMegaMenu.displayedMenuMobile)navCollapse.css({height:'auto',overflow:'visible'});else navCollapse.css({height:0,overflow:'hidden'});}else{navCollapse.removeClass('collapse');if(navCollapse.height()<=0)navCollapse.css({height:'auto',overflow:'visible'});}};Drupal.TBMegaMenu.focusNextPrevElement=function(direction){var $current=$(document.activeElement);if($current.length){var $focusable=$(Drupal.TBMegaMenu.focusableElements).filter(function(){var $this=$(this);return $this.closest('.tb-megamenu-subnav').length===0&&$this.is(':visible');});var index=$focusable.index($current);if(index>-1){if(direction==='next')var nextElement=$focusable[index+1]||$focusable[0];else var nextElement=$focusable[index-1]||$focusable[0];nextElement.focus();}}};Drupal.behaviors.tbMegaMenuAction={attach:function(context,settings){$(once('tb-megamenu','.tb-megamenu',context)).each(function(){var navParent=document.querySelector('.tb-megamenu'),linkArray=new Array(),curPos=new Array(-1,-1,-1);$(this).find('.level-1').children('a, span').not('.mobile-only').each(function(i,toplink){linkArray[i]=new Array();linkArray[i][-1]=toplink;$(toplink).data({coordinate:[i,-1]});$(toplink).next().children().children().children('.mega-col-nav').each(function(j,column){if($(column).find(Drupal.TBMegaMenu.focusableElements).length>0){linkArray[i][j]=new Array();$(column).find(Drupal.TBMegaMenu.focusableElements).each(function(k,sublink){linkArray[i][j][k]=sublink;$(sublink).data({coordinate:[i,j,k]});});}});});$(this).find(Drupal.TBMegaMenu.focusableElements).focus(function(){curPos=$(this).data('coordinate');});function keydownEvent(k){switch(k.keyCode){case 9:k.preventDefault();nav_tab(k);break;case 13:nav_open_link();break;case 27:nav_esc();break;case 37:k.preventDefault();nav_left();break;case 38:k.preventDefault();nav_up();break;case 39:k.preventDefault();nav_right();break;case 40:k.preventDefault();nav_down();break;case 36:nav_home();break;case 35:nav_end();break;default:}}function nav_tab(k){if(nav_is_toplink())if(k.shiftKey)nav_prev_toplink();else nav_next_toplink();else if(k.shiftKey)nav_up();else nav_down();}function nav_open_link(){linkArray[curPos[0]][curPos[1]][curPos[2]].click();}function nav_esc(){nav_close_megamenu();}function nav_left(){if(nav_is_toplink())nav_prev_toplink();else nav_prev_column();}function nav_right(){if(nav_is_toplink())nav_next_toplink();else nav_next_column();}function nav_up(){if(nav_is_toplink())nav_prev_toplink();else if(linkArray[curPos[0]][curPos[1]][curPos[2]-1])if($(linkArray[curPos[0]][curPos[1]][curPos[2]-1]).is(':visible'))linkArray[curPos[0]][curPos[1]][curPos[2]-1].focus();else{curPos=[curPos[0],curPos[1],curPos[2]-1];nav_up();}else nav_prev_column();}function nav_down(){if(nav_is_toplink())nav_next_column();else if(linkArray[curPos[0]][curPos[1]][curPos[2]+1])linkArray[curPos[0]][curPos[1]][curPos[2]+1].focus();else nav_next_column();}function nav_home(){if(nav_is_toplink())linkArray[0][-1].focus();else linkArray[curPos[0]][0][0].focus();}function nav_end(){if(nav_is_toplink())linkArray.slice(-1)[0][-1].focus();else linkArray[curPos[0]].slice(-1)[0].slice(-1)[0].focus();}function nav_is_toplink(){return (curPos[1]<0);}function nav_close_megamenu(){$('.tb-megamenu .open').removeClass('open');ariaCheck();}function nav_next_toplink(){if(linkArray[curPos[0]+1])linkArray[curPos[0]+1][-1].focus();else{nav_close_megamenu();Drupal.TBMegaMenu.focusNextPrevElement('next');}}function nav_prev_toplink(){if(linkArray[curPos[0]-1])linkArray[curPos[0]-1][-1].focus();else Drupal.TBMegaMenu.focusNextPrevElement('prev');}function nav_prev_column(){if(linkArray[curPos[0]][curPos[1]-1][0])linkArray[curPos[0]][curPos[1]-1][0].focus();else nav_parent_toplink();}function nav_next_column(){if(linkArray[curPos[0]][curPos[1]+1])linkArray[curPos[0]][curPos[1]+1][0].focus();else nav_parent_toplink();}function nav_parent_toplink(){linkArray[curPos[0]][-1].focus();}var ariaCheck=function(){$("li.tb-megamenu-item",this).each(function(){if($(this).is('.mega-group'))if(!$(this).parents().is('.open'))$(this).children().attr('aria-expanded','false');else{if($(this).parents().is('.open'))$(this).children().attr('aria-expanded','true');}else if($(this).is('.dropdown')||$(this).is('.dropdown-submenu'))if(!$(this).is('.open'))$(this).children().attr('aria-expanded','false');else{if($(this).is('.open'))$(this).children().attr('aria-expanded','true');}else $(this).children().removeAttr('aria-expanded');});};var showMenu=function($subMenu,mm_timeout){if($subMenu.hasClass('mega')){$subMenu.addClass('animating');clearTimeout($subMenu.data('animatingTimeout'));$subMenu.data('animatingTimeout',setTimeout(function(){$subMenu.removeClass('animating');},mm_timeout));clearTimeout($subMenu.data('hoverTimeout'));$subMenu.data('hoverTimeout',setTimeout(function(){$subMenu.addClass('open');ariaCheck();},100));}else{clearTimeout($subMenu.data('hoverTimeout'));$subMenu.data('hoverTimeout',setTimeout(function(){$subMenu.addClass('open');ariaCheck();},100));}};var hideMenu=function($subMenu,mm_timeout){$subMenu.children('.dropdown-toggle').attr('aria-expanded','false');if($subMenu.hasClass('mega')){$subMenu.addClass('animating');clearTimeout($subMenu.data('animatingTimeout'));$subMenu.data('animatingTimeout',setTimeout(function(){$subMenu.removeClass('animating');},mm_timeout));clearTimeout($subMenu.data('hoverTimeout'));$subMenu.data('hoverTimeout',setTimeout(function(){$subMenu.removeClass('open');ariaCheck();},100));}else{clearTimeout($subMenu.data('hoverTimeout'));$subMenu.data('hoverTimeout',setTimeout(function(){$subMenu.removeClass('open');ariaCheck();},100));}};$('.tb-megamenu-button',this).click(function(){if(parseInt($(this).parent().children('.nav-collapse').height())){$(this).parent().children('.nav-collapse').css({height:0,overflow:'hidden'});Drupal.TBMegaMenu.displayedMenuMobile=false;}else{$(this).parent().children('.nav-collapse').css({height:'auto',overflow:'visible'});Drupal.TBMegaMenu.displayedMenuMobile=true;}});var isTouch=window.matchMedia('(pointer: coarse)').matches;if(!isTouch){var mm_duration=0;$('.tb-megamenu',context).each(function(){if($(this).data('duration'))mm_duration=$(this).data('duration');});var mm_timeout=mm_duration?100+mm_duration:500;$('.nav > li, li.mega',context).bind('mouseenter',function(event){showMenu($(this),mm_timeout);});$('.nav > li > .dropdown-toggle, li.mega > .dropdown-toggle',context).bind('focus',function(event){var $this=$(this);var $subMenu=$this.closest('li');showMenu($subMenu,mm_timeout);$(document).bind('focusin',function(event){if($subMenu.has(event.target).length)return;$(document).unbind(event);hideMenu($subMenu,mm_timeout);});});$('.nav > li, li.mega',context).bind('mouseleave',function(event){hideMenu($(this),mm_timeout);});$('a, span').focus(function(event){if(!$(this).parent().hasClass('tb-megamenu-item')&&!$(this).parents('.tb-megamenu-block').length)nav_close_megamenu();});$('.nav > li > a, li.mega > a').focus(function(event){var siblings=$(this).parents('.tb-megamenu-item').siblings();$.each(siblings,function(i,v){var cousins=$(v).find('.open');$.each(cousins,function(index,value){$(value).removeClass('open');ariaCheck($(this));});$(v).removeClass('open');ariaCheck();});if($(this).next(".tb-megamenu-submenu").length>0)if(!$(this).parent().hasClass("open"))$(this).parent().addClass("open");if(!$(this).closest('.tb-megamenu-item.dropdown').hasClass('open')&&$(this).closest('.tb-megamenu-item.dropdown').find('.tb-megamenu-submenu').length>0){$(this).closest('.tb-megamenu-item.dropdown').addClass('open');ariaCheck();}var parents=$(this).parents('.tb-megamenu-item.dropdown-submenu');$.each(parents,function(i,v){if(!$(v).hasClass('open')){$(v).addClass('open');ariaCheck();}});});}var createTouchMenu=function(items){items.children("a, span").each(function(){var $item=$(this);var tbitem=$(this).parent();$item.click(function(event){if($item.hasClass("tb-megamenu-clicked")){var $uri=$item.attr("href");if($uri)window.location.href=$uri;else{$item.removeClass("tb-megamenu-clicked");hideMenu(tbitem,mm_timeout);}}else{event.preventDefault();nav_close_megamenu();$(".tb-megamenu").find(".tb-megamenu-clicked").removeClass("tb-megamenu-clicked");$item.addClass("tb-megamenu-clicked");showMenu(tbitem,mm_timeout);}});});$(document).on('click',function(event){if($(event.target).closest('.tb-megamenu-nav').length===0){nav_close_megamenu();$(".tb-megamenu").find(".tb-megamenu-clicked").removeClass("tb-megamenu-clicked");};});};if(isTouch)createTouchMenu($(".tb-megamenu ul.nav li.mega",context).has(".dropdown-menu"));;$(window).on('load resize',function(){var windowWidth=window.innerWidth?window.innerWidth:$(window).width();if(windowWidth!=Drupal.TBMegaMenu.oldWindowWidth){Drupal.TBMegaMenu.oldWindowWidth=windowWidth;Drupal.TBMegaMenu.menuResponsive();if(windowWidth>=Drupal.TBMegaMenu.supportedScreens[0])navParent.addEventListener('keydown',keydownEvent);else navParent.removeEventListener('keydown',keydownEvent);}});});}};})(jQuery,Drupal,drupalSettings,once);;
(function($,Drupal,debounce){const cache={right:0,left:0,bottom:0,top:0};const cssVarPrefix='--drupal-displace-offset';const documentStyle=document.documentElement.style;const offsetKeys=Object.keys(cache);const offsetProps={};offsetKeys.forEach((edge)=>{offsetProps[edge]={enumerable:true,get(){return cache[edge];},set(value){if(value!==cache[edge])documentStyle.setProperty(`${cssVarPrefix}-${edge}`,`${value}px`);cache[edge]=value;}};});const offsets=Object.seal(Object.defineProperties({},offsetProps));function getRawOffset(el,edge){const $el=$(el);const documentElement=document.documentElement;let displacement=0;const horizontal=edge==='left'||edge==='right';let placement=$el.offset()[horizontal?'left':'top'];placement-=window[`scroll${horizontal?'X':'Y'}`]||document.documentElement[`scroll${horizontal?'Left':'Top'}`]||0;switch(edge){case 'top':displacement=placement+$el.outerHeight();break;case 'left':displacement=placement+$el.outerWidth();break;case 'bottom':displacement=documentElement.clientHeight-placement;break;case 'right':displacement=documentElement.clientWidth-placement;break;default:displacement=0;}return displacement;}function calculateOffset(edge){let edgeOffset=0;const displacingElements=document.querySelectorAll(`[data-offset-${edge}]`);const n=displacingElements.length;for(let i=0;i<n;i++){const el=displacingElements[i];if(el.style.display==='none')continue;let displacement=parseInt(el.getAttribute(`data-offset-${edge}`),10);if(isNaN(displacement))displacement=getRawOffset(el,edge);edgeOffset=Math.max(edgeOffset,displacement);}return edgeOffset;}function displace(broadcast=true){const newOffsets={};offsetKeys.forEach((edge)=>{newOffsets[edge]=calculateOffset(edge);});offsetKeys.forEach((edge)=>{offsets[edge]=newOffsets[edge];});if(broadcast)$(document).trigger('drupalViewportOffsetChange',offsets);return offsets;}Drupal.behaviors.drupalDisplace={attach(){if(this.displaceProcessed)return;this.displaceProcessed=true;$(window).on('resize.drupalDisplace',debounce(displace,200));}};Drupal.displace=displace;Object.defineProperty(Drupal.displace,'offsets',{value:offsets,writable:false});Drupal.displace.calculateOffset=calculateOffset;})(jQuery,Drupal,Drupal.debounce);;
(function($,Drupal,once){if(once('drupal-dialog-deprecation-listener','html').length){const eventSpecial={handle($event){const $element=$($event.target);const event=$event.originalEvent;const dialog=event.dialog;const dialogArguments=[$event,dialog,$element,event?.settings];$event.handleObj.handler.apply(this,dialogArguments);}};$.event.special['dialog:beforecreate']=eventSpecial;$.event.special['dialog:aftercreate']=eventSpecial;$.event.special['dialog:beforeclose']=eventSpecial;$.event.special['dialog:afterclose']=eventSpecial;const listenDialogEvent=(event)=>{const windowEvents=$._data(window,'events');const isWindowHasDialogListener=windowEvents[event.type];if(isWindowHasDialogListener)Drupal.deprecationError({message:`jQuery event ${event.type} is deprecated in 10.3.0 and is removed from Drupal:12.0.0. See https://www.drupal.org/node/3422670`});};['dialog:beforecreate','dialog:aftercreate','dialog:beforeclose','dialog:afterclose'].forEach((e)=>window.addEventListener(e,listenDialogEvent));}})(jQuery,Drupal,once);;
class DrupalDialogEvent extends Event{constructor(type,dialog,settings=null){super(`dialog:${type}`,{bubbles:true});this.dialog=dialog;this.settings=settings;}}(function($,Drupal,drupalSettings,bodyScrollLock){drupalSettings.dialog={autoOpen:true,dialogClass:'',buttonClass:'button',buttonPrimaryClass:'button--primary',close(event){Drupal.dialog(event.target).close();Drupal.detachBehaviors(event.target,null,'unload');}};Drupal.dialog=function(element,options){let undef;const $element=$(element);const domElement=$element.get(0);const dialog={open:false,returnValue:undef};function openDialog(settings){settings=$.extend({},drupalSettings.dialog,options,settings);const event=new DrupalDialogEvent('beforecreate',dialog,settings);domElement.dispatchEvent(event);$element.dialog(event.settings);dialog.open=true;if(event.settings.modal)bodyScrollLock.lock(domElement);domElement.dispatchEvent(new DrupalDialogEvent('aftercreate',dialog,event.settings));}function closeDialog(value){domElement.dispatchEvent(new DrupalDialogEvent('beforeclose',dialog));bodyScrollLock.clearBodyLocks();$element.dialog('close');dialog.returnValue=value;dialog.open=false;domElement.dispatchEvent(new DrupalDialogEvent('afterclose',dialog));}dialog.show=()=>{openDialog({modal:false});};dialog.showModal=()=>{openDialog({modal:true});};dialog.close=closeDialog;return dialog;};})(jQuery,Drupal,drupalSettings,bodyScrollLock);;
(function($,Drupal,drupalSettings,debounce,displace){drupalSettings.dialog=$.extend({autoResize:true,maxHeight:'95%'},drupalSettings.dialog);function resetPosition(options){const offsets=displace.offsets;const left=offsets.left-offsets.right;const top=offsets.top-offsets.bottom;const leftString=`${(left>0?'+':'-')+Math.abs(Math.round(left/2))}px`;const topString=`${(top>0?'+':'-')+Math.abs(Math.round(top/2))}px`;options.position={my:`center${left!==0?leftString:''} center${top!==0?topString:''}`,of:window};return options;}function resetSize(event){const positionOptions=['width','height','minWidth','minHeight','maxHeight','maxWidth','position'];let adjustedOptions={};let windowHeight=$(window).height();let option;let optionValue;let adjustedValue;for(let n=0;n<positionOptions.length;n++){option=positionOptions[n];optionValue=event.data.settings[option];if(optionValue)if(typeof optionValue==='string'&&optionValue.endsWith('%')&&/height/i.test(option)){windowHeight-=displace.offsets.top+displace.offsets.bottom;adjustedValue=parseInt(0.01*parseInt(optionValue,10)*windowHeight,10);if(option==='height'&&Math.round(event.data.$element.parent().outerHeight())<adjustedValue)adjustedValue='auto';adjustedOptions[option]=adjustedValue;}}if(!event.data.settings.modal)adjustedOptions=resetPosition(adjustedOptions);event.data.$element.dialog('option',adjustedOptions);event.data.$element?.get(0)?.dispatchEvent(new CustomEvent('dialogContentResize',{bubbles:true}));}window.addEventListener('dialog:aftercreate',(e)=>{const autoResize=debounce(resetSize,20);const $element=$(e.target);const {settings}=e;const eventData={settings,$element};if(settings.autoResize===true||settings.autoResize==='true'){const uiDialog=$element.dialog('option',{resizable:false,draggable:false}).dialog('widget');uiDialog[0].style.position='fixed';$(window).on('resize.dialogResize scroll.dialogResize',eventData,autoResize).trigger('resize.dialogResize');$(document).on('drupalViewportOffsetChange.dialogResize',eventData,autoResize);}});window.addEventListener('dialog:beforeclose',()=>{$(window).off('.dialogResize');$(document).off('.dialogResize');});})(jQuery,Drupal,drupalSettings,Drupal.debounce,Drupal.displace);;
(function($,{tabbable,isTabbable}){$.widget('ui.dialog',$.ui.dialog,{options:{buttonClass:'button',buttonPrimaryClass:'button--primary'},_createButtons(){const opts=this.options;let primaryIndex;let index;const il=opts.buttons.length;for(index=0;index<il;index++)if(opts.buttons[index].primary&&opts.buttons[index].primary===true){primaryIndex=index;delete opts.buttons[index].primary;break;}this._super();const $buttons=this.uiButtonSet.children().addClass(opts.buttonClass);if(typeof primaryIndex!=='undefined')$buttons.eq(index).addClass(opts.buttonPrimaryClass);},_focusTabbable(){let hasFocus=this._focusedElement?this._focusedElement.get(0):null;if(!hasFocus)hasFocus=this.element.find('[autofocus]').get(0);if(!hasFocus){const $elements=[this.element,this.uiDialogButtonPane];for(let i=0;i<$elements.length;i++){const element=$elements[i].get(0);if(element){const elementTabbable=tabbable(element);hasFocus=elementTabbable.length?elementTabbable[0]:null;}if(hasFocus)break;}}if(!hasFocus){const closeBtn=this.uiDialogTitlebarClose.get(0);hasFocus=closeBtn&&isTabbable(closeBtn)?closeBtn:null;}if(!hasFocus)hasFocus=this.uiDialog.get(0);$(hasFocus).eq(0).trigger('focus');}});})(jQuery,window.tabbable);;
(($)=>{$.widget('ui.dialog',$.ui.dialog,{_allowInteraction(event){if(event.target.classList===undefined)return this._super(event);return event.target.classList.contains('ck')||this._super(event);}});})(jQuery);;
(function($,Drupal,{focusable}){Drupal.behaviors.dialog={attach(context,settings){const $context=$(context);if(!$('#drupal-modal').length)$('<div id="drupal-modal" class="ui-front"></div>').hide().appendTo('body');const $dialog=$context.closest('.ui-dialog-content');if($dialog.length){if($dialog.dialog('option','drupalAutoButtons'))$dialog.trigger('dialogButtonsChange');setTimeout(function(){if(!$dialog[0].contains(document.activeElement)){$dialog.dialog('instance')._focusedElement=null;$dialog.dialog('instance')._focusTabbable();}},0);}const originalClose=settings.dialog.close;settings.dialog.close=function(event,...args){originalClose.apply(settings.dialog,[event,...args]);const $element=$(event.target);const ajaxContainer=$element.data('uiDialog')?$element.data('uiDialog').opener.closest('[data-drupal-ajax-container]'):[];if(ajaxContainer.length&&(document.activeElement===document.body||$(document.activeElement).not(':visible'))){const focusableChildren=focusable(ajaxContainer[0]);if(focusableChildren.length>0)setTimeout(()=>{focusableChildren[0].focus();},0);}$(event.target).remove();};},prepareDialogButtons($dialog){const buttons=[];const $buttons=$dialog.find('.form-actions input[type=submit], .form-actions a.button, .form-actions a.action-link');$buttons.each(function(){const $originalButton=$(this);this.style.display='none';buttons.push({text:$originalButton.html()||$originalButton.attr('value'),class:$originalButton.attr('class'),'data-once':$originalButton.data('once'),click(e){if($originalButton[0].tagName==='A')$originalButton[0].click();else $originalButton.trigger('mousedown').trigger('mouseup').trigger('click');e.preventDefault();}});});return buttons;}};Drupal.AjaxCommands.prototype.openDialog=function(ajax,response,status){if(!response.selector)return false;let $dialog=$(response.selector);if(!$dialog.length)$dialog=$(`<div id="${response.selector.replace(/^#/,'')}" class="ui-front"></div>`).appendTo('body');if(!ajax.wrapper)ajax.wrapper=$dialog.attr('id');response.command='insert';response.method='html';ajax.commands.insert(ajax,response,status);response.dialogOptions=response.dialogOptions||{};if(typeof response.dialogOptions.drupalAutoButtons==='undefined')response.dialogOptions.drupalAutoButtons=true;else if(response.dialogOptions.drupalAutoButtons==='false')response.dialogOptions.drupalAutoButtons=false;else response.dialogOptions.drupalAutoButtons=!!response.dialogOptions.drupalAutoButtons;if(!response.dialogOptions.buttons&&response.dialogOptions.drupalAutoButtons)response.dialogOptions.buttons=Drupal.behaviors.dialog.prepareDialogButtons($dialog);$dialog.on('dialogButtonsChange',()=>{const buttons=Drupal.behaviors.dialog.prepareDialogButtons($dialog);$dialog.dialog('option','buttons',buttons);});response.dialogOptions=response.dialogOptions||{};const dialog=Drupal.dialog($dialog.get(0),response.dialogOptions);if(response.dialogOptions.modal)dialog.showModal();else dialog.show();$dialog.parent().find('.ui-dialog-buttonset').addClass('form-actions');};Drupal.AjaxCommands.prototype.closeDialog=function(ajax,response,status){const $dialog=$(response.selector);if($dialog.length){Drupal.dialog($dialog.get(0)).close();if(!response.persist)$dialog.remove();}$dialog.off('dialogButtonsChange');};Drupal.AjaxCommands.prototype.setDialogOption=function(ajax,response,status){const $dialog=$(response.selector);if($dialog.length)$dialog.dialog('option',response.optionName,response.optionValue);};window.addEventListener('dialog:aftercreate',(event)=>{const $element=$(event.target);const dialog=event.dialog;$element.on('click.dialog','.dialog-cancel',(e)=>{dialog.close('cancel');e.preventDefault();e.stopPropagation();});});window.addEventListener('dialog:beforeclose',(e)=>{const $element=$(e.target);$element.off('.dialog');});Drupal.AjaxCommands.prototype.openModalDialogWithUrl=function(ajax,response){const dialogOptions=response.dialogOptions||{};const elementSettings={progress:{type:'throbber'},dialogType:'modal',dialog:dialogOptions,url:response.url,httpMethod:'GET'};Drupal.ajax(elementSettings).execute();};})(jQuery,Drupal,window.tabbable);;
(function($,Drupal,once){'use strict';if($.ui&&$.ui.dialog&&$.ui.dialog.prototype._allowInteraction){var _allowInteraction=$.ui.dialog.prototype._allowInteraction;$.ui.dialog.prototype._allowInteraction=function(event){if($(event.target).closest('.cke_dialog').length)return true;return _allowInteraction.apply(this,arguments);};}Drupal.behaviors.webformDialogEvents={attach:function(){if(once('webform-dialog','html').length)$(window).on({'dialog:aftercreate':function(event,dialog,$element,settings){setTimeout(function(){var hasFocus=$element.find('[autofocus]:tabbable');if(!hasFocus.length)hasFocus=$element.find(':input:tabbable:not(:button)');if(!hasFocus.length)hasFocus=$element.parent().find('.ui-dialog-titlebar-close');hasFocus.eq(0).trigger('focus');});}});}};})(jQuery,Drupal,once);;
(function($,Drupal,drupalSettings,once){'use strict';Drupal.webform=Drupal.webform||{};Drupal.webform.dialog=Drupal.webform.dialog||{};Drupal.webform.dialog.options=Drupal.webform.dialog.options||{};Drupal.webformOpenDialog=function(url,type){var $div=$('<div><a href="'+url+'" class="webform-dialog '+type+'"></a></div>');Drupal.behaviors.webformDialog.attach($div.get(0));$div.find('a').trigger('click');};Drupal.behaviors.webformDialog={attach:function(context){$(once('webform-dialog','a.webform-dialog',context)).each(function(){var $a=$(this);var options=$.extend({},Drupal.webform.dialog.options);if($a.attr('class').match(/webform-dialog-([a-z0-9_]+)/)){var dialogOptionsName=RegExp.$1;if(drupalSettings.webform.dialog.options[dialogOptionsName]){options=drupalSettings.webform.dialog.options[dialogOptionsName];delete options.title;}}if($(this).data('dialog-options'))$.extend(options,$(this).data('dialog-options'));var href=$a.attr('href');if(href.indexOf('?source_entity_type=ENTITY_TYPE&source_entity_id=ENTITY_ID')!==-1){if(drupalSettings.webform.dialog.entity_type&&drupalSettings.webform.dialog.entity_id){href=href.replace('ENTITY_TYPE',encodeURIComponent(drupalSettings.webform.dialog.entity_type));href=href.replace('ENTITY_ID',encodeURIComponent(drupalSettings.webform.dialog.entity_id));}else href=href.replace('?source_entity_type=ENTITY_TYPE&source_entity_id=ENTITY_ID','');$a.attr('href',href);}href+=(href.indexOf('?')===-1?'?':'&')+'_webform_dialog=1';var element_settings={};element_settings.progress={type:'fullscreen'};element_settings.url=href;element_settings.event='touchstart click';element_settings.dialogType=$a.data('dialog-type')||'modal';element_settings.dialog=options;element_settings.element=this;element_settings.error=function error(xmlhttp,uri){if(xmlhttp.status===403)window.location.replace(href.split('?')[0]);};Drupal.ajax(element_settings);});}};})(jQuery,Drupal,drupalSettings,once);;
(function($,Drupal,once){'use strict';var hasLocalStorage=(function(){try{localStorage.setItem('webform','webform');localStorage.removeItem('webform');return true;}catch(e){return false;}}());Drupal.behaviors.webformDetailsSave={attach:function(context){if(!hasLocalStorage)return;$(once('webform-details-summary-save','details > summary',context)).on('click',function(){var $details=$(this).parent();if($details[0].hasAttribute('data-webform-details-nosave'))return;var name=Drupal.webformDetailsSaveGetName($details);if(!name)return;var open=($details.attr('open')!=='open')?'1':'0';localStorage.setItem(name,open);});$(once('webform-details-save','details',context)).each(function(){var $details=$(this);var name=Drupal.webformDetailsSaveGetName($details);if(!name)return;var open=localStorage.getItem(name);if(open===null)return;if(open==='1')$details.attr('open','open');else $details.removeAttr('open');});}};Drupal.webformDetailsSaveGetName=function($details){if(!hasLocalStorage)return '';if($details.hasClass('vertical-tabs__pane'))return '';var webformId=$details.attr('data-webform-element-id');if(webformId)return 'Drupal.webform.'+webformId.replace('--','.');var detailsId=$details.attr('id');if(!detailsId)return '';var $form=$details.parents('form');if(!$form.length||!$form.attr('id'))return '';var formId=$form.attr('id');if(!formId)return '';formId=formId.replace(/--.+?$/,'').replace(/-/g,'_');detailsId=detailsId.replace(/--.+?$/,'').replace(/-/g,'_');return 'Drupal.webform.'+formId+'.'+detailsId;};})(jQuery,Drupal,once);;
(function($,Drupal,once){'use strict';Drupal.webform=Drupal.webform||{};Drupal.webform.detailsToggle=Drupal.webform.detailsToggle||{};Drupal.webform.detailsToggle.options=Drupal.webform.detailsToggle.options||{};Drupal.behaviors.webformDetailsToggle={attach:function(context){$(once('webform-details-toggle','.js-webform-details-toggle',context)).each(function(){var $form=$(this);var $tabs=$form.find('.webform-tabs');var selector=($tabs.length)?'.webform-tab':'.js-webform-details-toggle, .webform-elements';var $details=$form.find('details').filter(function(){var $parents=$(this).parentsUntil(selector);return ($parents.find('details').length===0);});if($details.length<2)return;var options=$.extend({button:'<button type="button" class="webform-details-toggle-state"></button>'},Drupal.webform.detailsToggle.options);var $toggle=$(options.button).attr('title',Drupal.t('Toggle details widget state.')).on('click',function(e){var $details=$form.find('details:not(.vertical-tabs__pane)');var $summary=$details.find('summary');var open;if(Drupal.webform.detailsToggle.isFormDetailsOpen($form)){$details.removeAttr('open');$summary.attr('aria-expanded','false');open=0;}else{$details.attr('open','open');$summary.attr('aria-expanded','true');open=1;}Drupal.webform.detailsToggle.setDetailsToggleLabel($form);if(Drupal.webformDetailsSaveGetName)$details.each(function(){var name=Drupal.webformDetailsSaveGetName($(this));if(name)localStorage.setItem(name,open);});}).wrap('<div class="webform-details-toggle-state-wrapper"></div>').parent();if($tabs.length)$tabs.find('.item-list:first-child').eq(0).before($toggle);else $details.eq(0).before($toggle);Drupal.webform.detailsToggle.setDetailsToggleLabel($form);});}};Drupal.webform.detailsToggle.isFormDetailsOpen=function($form){return ($form.find('details[open]').length===$form.find('details').length);};Drupal.webform.detailsToggle.setDetailsToggleLabel=function($form){var isOpen=Drupal.webform.detailsToggle.isFormDetailsOpen($form);var label=(isOpen)?Drupal.t('Collapse all'):Drupal.t('Expand all');$form.find('.webform-details-toggle-state').html(label);var text=(isOpen)?Drupal.t('All details have been expanded.'):Drupal.t('All details have been collapsed.');Drupal.announce(text);};})(jQuery,Drupal,once);;
(function($,Drupal,once){'use strict';var hasLocalStorage=(function(){try{localStorage.setItem('webform','webform');localStorage.removeItem('webform');return true;}catch(e){return false;}}());var hasSessionStorage=(function(){try{sessionStorage.setItem('webform','webform');sessionStorage.removeItem('webform');return true;}catch(e){return false;}}());Drupal.behaviors.webformMessageClose={attach:function(context){$(once('webform-message--close','.js-webform-message--close',context)).each(function(){var $element=$(this);var id=$element.attr('data-message-id');var storage=$element.attr('data-message-storage');var effect=$element.attr('data-message-close-effect')||'hide';switch(effect){case 'slide':effect='slideUp';break;case 'fade':effect='fadeOut';break;}if(isClosed($element,storage,id))return;if($element.attr('style')!=='display: none;'&&!$element.hasClass('js-webform-states-hidden'))$element.show();$element.find('.js-webform-message__link').on('click',function(event){$element[effect]();setClosed($element,storage,id);$element.trigger('close');event.preventDefault();});});}};function isClosed($element,storage,id){if(!id||!storage)return false;switch(storage){case 'local':if(hasLocalStorage)return localStorage.getItem('Drupal.webform.message.'+id)||false;return false;case 'session':if(hasSessionStorage)return sessionStorage.getItem('Drupal.webform.message.'+id)||false;return false;default:return false;}}function setClosed($element,storage,id){if(!id||!storage)return;switch(storage){case 'local':if(hasLocalStorage)localStorage.setItem('Drupal.webform.message.'+id,true);break;case 'session':if(hasSessionStorage)sessionStorage.setItem('Drupal.webform.message.'+id,true);break;case 'user':case 'state':case 'custom':$.get($element.find('.js-webform-message__link').attr('href'));return true;}}})(jQuery,Drupal,once);;
(function($,Drupal,debounce){$.fn.drupalGetSummary=function(){const callback=this.data('summaryCallback');if(!this[0]||!callback)return '';const result=callback(this[0]);return result?result.trim():'';};$.fn.drupalSetSummary=function(callback){const self=this;if(typeof callback!=='function'){const val=callback;callback=function(){return val;};}return (this.data('summaryCallback',callback).off('formUpdated.summary').on('formUpdated.summary',()=>{self.trigger('summaryUpdated');}).trigger('summaryUpdated'));};Drupal.behaviors.formSingleSubmit={attach(){function onFormSubmit(e){const $form=$(e.currentTarget);const formValues=new URLSearchParams(new FormData(e.target)).toString();const previousValues=$form.attr('data-drupal-form-submit-last');if(previousValues===formValues)e.preventDefault();else $form.attr('data-drupal-form-submit-last',formValues);}$(once('form-single-submit','body')).on('submit.singleSubmit','form:not([method~="GET"])',onFormSubmit);}};function triggerFormUpdated(element){$(element).trigger('formUpdated');}function fieldsList(form){return [].map.call(form.querySelectorAll('[name][id]'),(el)=>el.id);}Drupal.behaviors.formUpdated={attach(context){const $context=$(context);const contextIsForm=context.tagName==='FORM';const $forms=$(once('form-updated',contextIsForm?$context:$context.find('form')));let formFields;if($forms.length)$.makeArray($forms).forEach((form)=>{const events='change.formUpdated input.formUpdated ';const eventHandler=debounce((event)=>{triggerFormUpdated(event.target);},300);formFields=fieldsList(form).join(',');form.setAttribute('data-drupal-form-fields',formFields);$(form).on(events,eventHandler);});if(contextIsForm){formFields=fieldsList(context).join(',');const currentFields=$(context).attr('data-drupal-form-fields');if(formFields!==currentFields)triggerFormUpdated(context);}},detach(context,settings,trigger){const $context=$(context);const contextIsForm=context.tagName==='FORM';if(trigger==='unload')once.remove('form-updated',contextIsForm?$context:$context.find('form')).forEach((form)=>{form.removeAttribute('data-drupal-form-fields');$(form).off('.formUpdated');});}};Drupal.behaviors.fillUserInfoFromBrowser={attach(context,settings){const userInfo=['name','mail','homepage'];const $forms=$(once('user-info-from-browser','[data-user-info-from-browser]'));if($forms.length)userInfo.forEach((info)=>{const $element=$forms.find(`[name=${info}]`);const browserData=localStorage.getItem(`Drupal.visitor.${info}`);if(!$element.length)return;const emptyValue=$element[0].value==='';const defaultValue=$element.attr('data-drupal-default-value')===$element[0].value;if(browserData&&(emptyValue||defaultValue))$element.each(function(index,item){item.value=browserData;});});$forms.on('submit',()=>{userInfo.forEach((info)=>{const $element=$forms.find(`[name=${info}]`);if($element.length)localStorage.setItem(`Drupal.visitor.${info}`,$element[0].value);});});}};const handleFragmentLinkClickOrHashChange=(e)=>{let url;if(e.type==='click')url=e.currentTarget.location?e.currentTarget.location:e.currentTarget;else url=window.location;const hash=url.hash.substring(1);if(hash){const $target=$(`#${hash}`);$('body').trigger('formFragmentLinkClickOrHashChange',[$target]);setTimeout(()=>$target.trigger('focus'),300);}};const debouncedHandleFragmentLinkClickOrHashChange=debounce(handleFragmentLinkClickOrHashChange,300,true);$(window).on('hashchange.form-fragment',debouncedHandleFragmentLinkClickOrHashChange);$(document).on('click.form-fragment','a[href*="#"]',debouncedHandleFragmentLinkClickOrHashChange);})(jQuery,Drupal,Drupal.debounce);;
(function($,Drupal){'use strict';var isChrome=(/chrom(e|ium)/.test(window.navigator.userAgent.toLowerCase()));if(isChrome){var backButton=false;if(window.performance){var navEntries=window.performance.getEntriesByType('navigation');if(navEntries.length>0&&navEntries[0].type==='back_forward')backButton=true;else{if(window.performance.navigation&&window.performance.navigation.type===window.performance.navigation.TYPE_BACK_FORWARD)backButton=true;}}if(backButton){var attachBehaviors=Drupal.attachBehaviors;Drupal.attachBehaviors=function(context,settings){setTimeout(function(){attachBehaviors(context,settings);},300);};}}})(jQuery,Drupal);;
(function($,Drupal){const states={postponed:[]};Drupal.states=states;function invert(a,invertState){return invertState&&typeof a!=='undefined'?!a:a;}function compare(a,b){if(a===b)return typeof a==='undefined'?a:true;return typeof a==='undefined'||typeof b==='undefined';}function ternary(a,b){if(typeof a==='undefined')return b;if(typeof b==='undefined')return a;return a&&b;}Drupal.behaviors.states={attach(context,settings){const elements=once('states','[data-drupal-states]',context);const il=elements.length;for(let i=0;i<il;i++){const config=JSON.parse(elements[i].getAttribute('data-drupal-states'));Object.keys(config||{}).forEach((state)=>{new states.Dependent({element:$(elements[i]),state:states.State.sanitize(state),constraints:config[state]});});}while(states.postponed.length)states.postponed.shift()();}};states.Dependent=function(args){$.extend(this,{values:{},oldValue:null},args);this.dependees=this.getDependees();Object.keys(this.dependees||{}).forEach((selector)=>{this.initializeDependee(selector,this.dependees[selector]);});};states.Dependent.comparisons={RegExp(reference,value){return reference.test(value);},Function(reference,value){return reference(value);},Array(reference,value){if(!Array.isArray(value))return false;return JSON.stringify(reference.sort())===JSON.stringify(value.sort());},Number(reference,value){return typeof value==='string'?compare(reference.toString(),value):compare(reference,value);}};states.Dependent.prototype={initializeDependee(selector,dependeeStates){this.values[selector]={};Object.keys(dependeeStates).forEach((i)=>{let state=dependeeStates[i];if($.inArray(state,dependeeStates)===-1)return;state=states.State.sanitize(state);this.values[selector][state.name]=null;$(selector).on(`state:${state}`,{selector,state},(e)=>{this.update(e.data.selector,e.data.state,e.value);});new states.Trigger({selector,state});});},compare(reference,selector,state){const value=this.values[selector][state.name];if(reference.constructor.name in states.Dependent.comparisons)return states.Dependent.comparisons[reference.constructor.name](reference,value);return compare(reference,value);},update(selector,state,value){if(value!==this.values[selector][state.name]){this.values[selector][state.name]=value;this.reevaluate();}},reevaluate(){let value=this.verifyConstraints(this.constraints);if(value!==this.oldValue){this.oldValue=value;value=invert(value,this.state.invert);this.element.trigger({type:`state:${this.state}`,value,trigger:true});}},verifyConstraints(constraints,selector){let result;if(Array.isArray(constraints)){const hasXor=$.inArray('xor',constraints)===-1;const len=constraints.length;for(let i=0;i<len;i++)if(constraints[i]!=='xor'){const constraint=this.checkConstraints(constraints[i],selector,i);if(constraint&&(hasXor||result))return hasXor;result=result||constraint;}}else{if($.isPlainObject(constraints)){for(const n in constraints)if(constraints.hasOwnProperty(n)){result=ternary(result,this.checkConstraints(constraints[n],selector,n));if(result===false)return false;}}}return result;},checkConstraints(value,selector,state){if(typeof state!=='string'||/[0-9]/.test(state[0]))state=null;else{if(typeof selector==='undefined'){selector=state;state=null;}}if(state!==null){state=states.State.sanitize(state);return invert(this.compare(value,selector,state),state.invert);}return this.verifyConstraints(value,selector);},getDependees(){const cache={};const _compare=this.compare;this.compare=function(reference,selector,state){(cache[selector]||(cache[selector]=[])).push(state.name);};this.verifyConstraints(this.constraints);this.compare=_compare;return cache;}};states.Trigger=function(args){$.extend(this,args);if(this.state in states.Trigger.states){this.element=$(this.selector);if(!this.element.data(`trigger:${this.state}`))this.initialize();}};states.Trigger.prototype={initialize(){const trigger=states.Trigger.states[this.state];if(typeof trigger==='function')trigger.call(window,this.element);else Object.keys(trigger||{}).forEach((event)=>{this.defaultTrigger(event,trigger[event]);});this.element.data(`trigger:${this.state}`,true);},defaultTrigger(event,valueFn){let oldValue=valueFn.call(this.element);this.element.on(event,function(e){const value=valueFn.call(this.element,e);if(oldValue!==value){this.element.trigger({type:`state:${this.state}`,value,oldValue});oldValue=value;}}.bind(this));states.postponed.push(function(){this.element.trigger({type:`state:${this.state}`,value:oldValue,oldValue:null});}.bind(this));}};states.Trigger.states={empty:{keyup(){return this.val()==='';},change(){return this.val()==='';}},checked:{change(){let checked=false;this.each(function(){checked=$(this).prop('checked');return !checked;});return checked;}},value:{keyup(){if(this.length>1)return this.filter(':checked').val()||false;return this.val();},change(){if(this.length>1)return this.filter(':checked').val()||false;return this.val();}},collapsed:{collapsed(e){return typeof e!=='undefined'&&'value' in e?e.value:!this[0].hasAttribute('open');}}};states.State=function(state){this.pristine=state;this.name=state;let process=true;do{while(this.name.charAt(0)==='!'){this.name=this.name.substring(1);this.invert=!this.invert;}if(this.name in states.State.aliases)this.name=states.State.aliases[this.name];else process=false;}while(process);};states.State.sanitize=function(state){if(state instanceof states.State)return state;return new states.State(state);};states.State.aliases={enabled:'!disabled',invisible:'!visible',invalid:'!valid',untouched:'!touched',optional:'!required',filled:'!empty',unchecked:'!checked',irrelevant:'!relevant',expanded:'!collapsed',open:'!collapsed',closed:'collapsed',readwrite:'!readonly'};states.State.prototype={invert:false,toString(){return this.name;}};const $document=$(document);$document.on('state:disabled',(e)=>{const tagsSupportDisable='button, fieldset, optgroup, option, select, textarea, input';if(e.trigger)$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper').toggleClass('form-disabled',e.value).find(tagsSupportDisable).addBack(tagsSupportDisable).prop('disabled',e.value);});$document.on('state:readonly',(e)=>{if(e.trigger)$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper').toggleClass('form-readonly',e.value).find('input, textarea').prop('readonly',e.value);});$document.on('state:required',(e)=>{if(e.trigger)if(e.value){const label=`label${e.target.id?`[for=${e.target.id}]`:''}`;const $label=$(e.target).attr({required:'required','aria-required':'true'}).closest('.js-form-item, .js-form-wrapper').find(label);if(!$label.hasClass('js-form-required').length)$label.addClass('js-form-required form-required');}else $(e.target).removeAttr('required aria-required').closest('.js-form-item, .js-form-wrapper').find('label.js-form-required').removeClass('js-form-required form-required');});$document.on('state:visible',(e)=>{if(e.trigger){let $element=$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper');if(e.target.tagName==='A')$element=$(e.target);$element.toggle(e.value);}});$document.on('state:checked',(e)=>{if(e.trigger)$(e.target).closest('.js-form-item, .js-form-wrapper').find('input').prop('checked',e.value).trigger('change');});$document.on('state:collapsed',(e)=>{if(e.trigger)if(e.target.hasAttribute('open')===e.value)$(e.target).find('> summary').trigger('click');});})(jQuery,Drupal);;
(function($,Drupal,once){'use strict';Drupal.webform=Drupal.webform||{};Drupal.webform.states=Drupal.webform.states||{};Drupal.webform.states.slideDown=Drupal.webform.states.slideDown||{};Drupal.webform.states.slideDown.duration='slow';Drupal.webform.states.slideUp=Drupal.webform.states.slideUp||{};Drupal.webform.states.slideUp.duration='fast';$.fn.hasData=function(data){return (typeof this.data(data)!=='undefined');};$.fn.isWebform=function(){return $(this).closest('form.webform-submission-form, form[id^="webform"], form[data-is-webform]').length?true:false;};$.fn.isWebformElement=function(){return ($(this).isWebform()||$(this).closest('[data-is-webform-element]').length)?true:false;};Drupal.states.Trigger.states.empty.change=function change(){return this.val()==='';};var states=Drupal.states;Drupal.states.Dependent.prototype.compare=function compare(reference,selector,state){var value=this.values[selector][state.name];var name=reference.constructor.name;if(!name){name=$.type(reference);name=name.charAt(0).toUpperCase()+name.slice(1);}if(name in states.Dependent.comparisons)return states.Dependent.comparisons[name](reference,value);if(reference.constructor.name in states.Dependent.comparisons)return states.Dependent.comparisons[reference.constructor.name](reference,value);return _compare2(reference,value);};function _compare2(a,b){if(a===b)return typeof a==='undefined'?a:true;return typeof a==='undefined'||typeof b==='undefined';}Drupal.states.Dependent.comparisons.Object=function(reference,value){if('pattern' in reference)return (new RegExp(reference['pattern'])).test(value);else if('!pattern' in reference)return !((new RegExp(reference['!pattern'])).test(value));else if('less' in reference)return (value!==''&&parseFloat(reference['less'])>parseFloat(value));else if('less_equal' in reference)return (value!==''&&parseFloat(reference['less_equal'])>=parseFloat(value));else if('greater' in reference)return (value!==''&&parseFloat(reference['greater'])<parseFloat(value));else if('greater_equal' in reference)return (value!==''&&parseFloat(reference['greater_equal'])<=parseFloat(value));else if('between' in reference||'!between' in reference){if(value==='')return false;var between=reference['between']||reference['!between'];var betweenParts=between.split(':');var greater=betweenParts[0];var less=(typeof betweenParts[1]!=='undefined')?betweenParts[1]:null;var isGreaterThan=(greater===null||greater===''||parseFloat(value)>=parseFloat(greater));var isLessThan=(less===null||less===''||parseFloat(value)<=parseFloat(less));var result=(isGreaterThan&&isLessThan);return (reference['!between'])?!result:result;}else return reference.indexOf(value)!==false;};var $document=$(document);$document.on('state:required',function(e){if(e.trigger&&$(e.target).isWebformElement()){var $target=$(e.target);toggleRequired($target.find('input[type="file"]'),e.value);if($target.is('.js-form-type-radios, .js-form-type-webform-radios-other, .js-webform-type-radios, .js-webform-type-webform-radios-other, .js-webform-type-webform-entity-radios, .webform-likert-table')){$target.toggleClass('required',e.value);toggleRequired($target.find('input[type="radio"]'),e.value);}if($target.is('.js-form-type-checkboxes, .js-form-type-webform-checkboxes-other, .js-webform-type-checkboxes, .js-webform-type-webform-checkboxes-other')){$target.toggleClass('required',e.value);var $checkboxes=$target.find('input[type="checkbox"]');if(e.value){$checkboxes.on('click',statesCheckboxesRequiredEventHandler);checkboxesRequired($target);}else{$checkboxes.off('click',statesCheckboxesRequiredEventHandler);toggleRequired($checkboxes,false);}}if($target.is('.js-webform-tableselect')){$target.toggleClass('required',e.value);var isMultiple=$target.is('[multiple]');if(isMultiple){var $tbody=$target.find('tbody');var $checkboxes=$tbody.find('input[type="checkbox"]');copyRequireMessage($target,$checkboxes);if(e.value){$checkboxes.on('click change',statesCheckboxesRequiredEventHandler);checkboxesRequired($tbody);}else{$checkboxes.off('click change ',statesCheckboxesRequiredEventHandler);toggleRequired($tbody,false);}}else{var $radios=$target.find('input[type="radio"]');copyRequireMessage($target,$radios);toggleRequired($radios,e.value);}}if($target.is('.js-form-type-webform-select-other, .js-webform-type-webform-select-other')){var $select=$target.find('select');toggleRequired($select,e.value);copyRequireMessage($target,$select);}if($target.find('> label:not([for])').length)$target.find('> label').toggleClass('js-form-required form-required',e.value);if($target.is('.js-webform-type-radios, .js-webform-type-checkboxes, fieldset'))$target.find('legend span.fieldset-legend:not(.visually-hidden),legend span.fieldset__label:not(.visually-hidden)').toggleClass('js-form-required form-required',e.value);if($target.is('fieldset'))$target.removeAttr('required aria-required');}});$document.on('state:checked',function(e){if(e.trigger)$(e.target).trigger('change');});$document.on('state:readonly',function(e){if(e.trigger&&$(e.target).isWebformElement()){$(e.target).prop('readonly',e.value).closest('.js-form-item, .js-form-wrapper').toggleClass('webform-readonly',e.value).find('input, textarea').prop('readonly',e.value);$(e.target).trigger('webform:readonly').find('select, input, textarea, button').trigger('webform:readonly');}});$document.on('state:visible state:visible-slide',function(e){if(e.trigger&&$(e.target).isWebformElement())if(e.value)$(':input',e.target).addBack().each(function(){restoreValueAndRequired(this);triggerEventHandlers(this);});else $(':input',e.target).addBack().each(function(){backupValueAndRequired(this);clearValueAndRequired(this);triggerEventHandlers(this);});});$document.on('state:visible-slide',function(e){if(e.trigger&&$(e.target).isWebformElement()){var effect=e.value?'slideDown':'slideUp';var duration=Drupal.webform.states[effect].duration;$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper')[effect](duration);}});Drupal.states.State.aliases['invisible-slide']='!visible-slide';$document.on('state:disabled',function(e){if(e.trigger&&$(e.target).isWebformElement()){$(e.target).prop('disabled',e.value).closest('.js-form-item, .js-form-submit, .js-form-wrapper').toggleClass('form-disabled',e.value).find('select, input, textarea, button').prop('disabled',e.value);var fileElements=$(e.target).find(':input[type="hidden"][name$="[fids]"]');if(fileElements.length){if($(e.target).is('fieldset'))$(e.target).prop('disabled',false);fileElements.removeAttr('disabled');}$(e.target).trigger('webform:disabled').find('select, input, textarea, button').trigger('webform:disabled');}});Drupal.behaviors.webformCheckboxesRequired={attach:function(context){$(once('webform-checkboxes-required','.js-form-type-checkboxes.required, .webform-term-checkboxes.required, .js-form-type-webform-checkboxes-other.required, .js-webform-type-checkboxes.required, .js-webform-type-webform-checkboxes-other.required, .js-webform-type-webform-radios-other.checkboxes',context)).each(function(){var $element=$(this);$element.find('input[type="checkbox"]').on('click',statesCheckboxesRequiredEventHandler);setTimeout(function(){checkboxesRequired($element);});});}};Drupal.behaviors.webformRadiosRequired={attach:function(context){$(once('webform-radios-required','.js-form-type-radios, .js-form-type-webform-radios-other, .js-webform-type-radios, .js-webform-type-webform-radios-other, .js-webform-type-webform-entity-radios, .js-webform-type-webform-scale',context)).each(function(){var $element=$(this);setTimeout(function(){radiosRequired($element);});});}};Drupal.behaviors.webformTableSelectRequired={attach:function(context){$(once('webform-tableselect-required','.js-webform-tableselect.required',context)).each(function(){var $element=$(this);var $tbody=$element.find('tbody');var isMultiple=$element.is('[multiple]');if(isMultiple)$tbody.find('input[type="checkbox"]').on('click change',function(){checkboxesRequired($tbody);});setTimeout(function(){isMultiple?checkboxesRequired($tbody):radiosRequired($element);});});}};function checkboxesRequired($element){var $firstCheckbox=$element.find('input[type="checkbox"]').first();var isChecked=$element.find('input[type="checkbox"]').is(':checked');toggleRequired($firstCheckbox,!isChecked);copyRequireMessage($element,$firstCheckbox);}function radiosRequired($element){var $radios=$element.find('input[type="radio"]');var isRequired=$element.hasClass('required');toggleRequired($radios,isRequired);copyRequireMessage($element,$radios);}function statesCheckboxesRequiredEventHandler(){var $element=$(this).closest('.js-webform-type-checkboxes, .js-webform-type-webform-checkboxes-other, .js-webform-type-webform-term-checkboxes, .js-webform-tableselect tbody');checkboxesRequired($element);}function triggerEventHandlers(input){var $input=$(input);var type=input.type;var tag=input.tagName.toLowerCase();var extraParameters=['webform.states'];if(type==='checkbox'||type==='radio')$input.trigger('change',extraParameters).trigger('blur',extraParameters);else if(tag==='select'){if($input.closest('.webform-type-address').length){if(!$input.data('webform-states-address-initialized')&&$input.attr('autocomplete')==='country'&&$input.val()===$input.find("option[selected]").attr('value'))return;$input.data('webform-states-address-initialized',true);}$input.trigger('change',extraParameters).trigger('blur',extraParameters);}else{if(type!=='submit'&&type!=='button'&&type!=='file'){var hasInputMask=($.fn.inputmask&&$input.hasClass('js-webform-input-mask'));hasInputMask&&$input.inputmask('remove');$input.trigger('input',extraParameters).trigger('change',extraParameters).trigger('keydown',extraParameters).trigger('keyup',extraParameters).trigger('blur',extraParameters);hasInputMask&&$input.inputmask();}}}function backupValueAndRequired(input){var $input=$(input);var type=input.type;var tag=input.tagName.toLowerCase();if($input.prop('required')&&!$input.hasData('webform-required'))$input.data('webform-required',true);if(!$input.hasData('webform-value'))if(type==='checkbox'||type==='radio')$input.data('webform-value',$input.prop('checked'));else if(tag==='select'){var values=[];$input.find('option:selected').each(function(i,option){values[i]=option.value;});$input.data('webform-value',values);}else{if(type!=='submit'&&type!=='button')$input.data('webform-value',input.value);}}function restoreValueAndRequired(input){var $input=$(input);var value=$input.data('webform-value');if(typeof value!=='undefined'){var type=input.type;var tag=input.tagName.toLowerCase();if(type==='checkbox'||type==='radio')$input.prop('checked',value);else if(tag==='select')$.each(value,function(i,option_value){option_value=option_value.replace(/'/g,"\\\'");$input.find("option[value='"+option_value+"']").prop('selected',true);});else{if(type!=='submit'&&type!=='button')input.value=value;}$input.removeData('webform-value');}var required=$input.data('webform-required');if(typeof required!=='undefined'){if(required)$input.prop('required',true);$input.removeData('webform-required');}}function clearValueAndRequired(input){var $input=$(input);if($input.closest('[data-webform-states-no-clear]').length)return;var type=input.type;var tag=input.tagName.toLowerCase();if(type==='checkbox'||type==='radio')$input.prop('checked',false);else if(tag==='select')if($input.find('option[value=""]').length)$input.val('');else input.selectedIndex=-1;else{if(type!=='submit'&&type!=='button')input.value=(type==='color')?'#000000':'';}$input.prop('required',false);}function toggleRequired($input,required){var isCheckboxOrRadio=($input.attr('type')==='radio'||$input.attr('type')==='checkbox');if(required)if(isCheckboxOrRadio)$input.attr({'required':'required'});else $input.attr({'required':'required','aria-required':'true'});else{if(isCheckboxOrRadio)$input.removeAttr('required');else $input.removeAttr('required aria-required');$input.each(function(){this.setCustomValidity&&this.setCustomValidity('');});}}function copyRequireMessage($source,$destination){if($source.attr('data-msg-required'))$destination.attr('data-msg-required',$source.attr('data-msg-required'));}})(jQuery,Drupal,once);;
(function($,Drupal,once){'use strict';Drupal.behaviors.webformRemoveFormSingleSubmit={attach:function attach(){function onFormSubmit(e){var $form=$(e.currentTarget);$form.removeAttr('data-drupal-form-submit-last');}$(once('webform-single-submit','body')).on('submit.singleSubmit','form.webform-remove-single-submit',onFormSubmit);}};Drupal.behaviors.webformDisableAutoSubmit={attach:function(context){$(once('webform-disable-autosubmit',$('.js-webform-disable-autosubmit input').not(':button, :submit, :reset, :image, :file'))).on('keyup keypress',function(e){if(e.which===13){e.preventDefault();return false;}});}};Drupal.behaviors.webformRequiredError={attach:function(context){$(once('webform-required-error',$(context).find(':input[data-webform-required-error], :input[data-webform-pattern-error]'))).on('invalid',function(){this.setCustomValidity('');if(this.valid)return;if(this.validity.patternMismatch&&$(this).attr('data-webform-pattern-error'))this.setCustomValidity($(this).attr('data-webform-pattern-error'));else{if(this.validity.valueMissing&&$(this).attr('data-webform-required-error'))this.setCustomValidity($(this).attr('data-webform-required-error'));}}).on('input change',function(){var name=$(this).attr('name');$(this.form).find(':input[name="'+name+'"]').each(function(){this.setCustomValidity('');});});}};$(document).on('state:required',function(e){$(e.target).filter(':input[data-webform-required-error]').each(function(){this.setCustomValidity('');});});})(jQuery,Drupal,once);;
