<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* themes/custom/divihn_bootstrap/templates/paragraph/paragraph--text-block.html.twig */
class __TwigTemplate_9a24a137f8d49dc5244fcfd467cc6d6f extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'paragraph' => [$this, 'block_paragraph'],
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 42
        $context["classes"] = ["paragraph", ("paragraph--type--" . \Drupal\Component\Utility\Html::getClass(CoreExtension::getAttribute($this->env, $this->source,         // line 44
($context["paragraph"] ?? null), "bundle", [], "any", false, false, true, 44))), ((        // line 45
($context["view_mode"] ?? null)) ? (("paragraph--view-mode--" . \Drupal\Component\Utility\Html::getClass(($context["view_mode"] ?? null)))) : ("")), (( !CoreExtension::getAttribute($this->env, $this->source,         // line 46
($context["paragraph"] ?? null), "isPublished", [], "method", false, false, true, 46)) ? ("paragraph--unpublished") : (""))];
        // line 49
        yield from $this->unwrap()->yieldBlock('paragraph', $context, $blocks);
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["paragraph", "view_mode", "attributes", "content"]);        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_paragraph(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 50
        yield "<section";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["attributes"] ?? null), "addClass", ["text-block-section", "py-5", "ourPromiseWrapp"], "method", false, false, true, 50), "html", null, true);
        yield ">
    <div class=\"ourPromise_top_curveline\">
        <img style=\"color:transparent;\" src=\"\\themes\\custom\\divihn_bootstrap\\images\\curve-outline-shape-zoom-top.209058c8.svg\" alt=\"TopCurveLine\" width=\"1920\" height=\"358\" loading=\"lazy\" decoding=\"async\" data-nimg=\"1\">
    </div>
  <div class=\"ourPromise\">
    ";
        // line 56
        yield "    <h2 class=\"sectionTitle lightBlue\">Our Promise</h2>
    <div class=\"headingBox\">
    <div class=\"text-bloc-body\">
      ";
        // line 59
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["content"] ?? null), "field_text", [], "any", false, false, true, 59), "html", null, true);
        yield "
    </div>

    ";
        // line 63
        yield "    <div class=\"text-bloc-curve\"></div>
  </div>
   </div>
      <div class=\"ourPromise_bottom_curveline\">
        <img style=\"color:transparent;\" src=\"\\themes\\custom\\divihn_bootstrap\\images\\curve-outline-shape-zoom-bottom.2b73c6c1.svg\" alt=\"BottomCurveLine\" width=\"1920\" height=\"704\" loading=\"lazy\" decoding=\"async\" data-nimg=\"1\">
    </div>
</section>
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "themes/custom/divihn_bootstrap/templates/paragraph/paragraph--text-block.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  82 => 63,  76 => 59,  71 => 56,  62 => 50,  50 => 49,  48 => 46,  47 => 45,  46 => 44,  45 => 42,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a paragraph.
 *
 * Available variables:
 * - paragraph: Full paragraph entity.
 *   Only method names starting with \"get\", \"has\", or \"is\" and a few common
 *   methods such as \"id\", \"label\", and \"bundle\" are available. For example:
 *   - paragraph.getCreatedTime() will return the paragraph creation timestamp.
 *   - paragraph.id(): The paragraph ID.
 *   - paragraph.bundle(): The type of the paragraph, for example, \"image\" or \"text\".
 *   - paragraph.getOwnerId(): The user ID of the paragraph author.
 *   See Drupal\\paragraphs\\Entity\\Paragraph for a full list of public properties
 *   and methods for the paragraph object.
 * - content: All paragraph items. Use {{ content }} to print them all,
 *   or print a subset such as {{ content.field_example }}. Use
 *   {{ content|without('field_example') }} to temporarily suppress the printing
 *   of a given child element.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class element may contain one or more of the following
 *   classes:
 *   - paragraphs: The current template type (also known as a \"theming hook\").
 *   - paragraphs--type-[type]: The current paragraphs type. For example, if the paragraph is an
 *     \"Image\" it would result in \"paragraphs--type--image\". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - paragraphs--view-mode--[view_mode]: The View Mode of the paragraph; for example, a
 *     preview would result in: \"paragraphs--view-mode--preview\", and
 *     default: \"paragraphs--view-mode--default\".
 * - view_mode: View mode; for example, \"preview\" or \"full\".
 * - logged_in: Flag for authenticated user status. Will be true when the
 *   current user is a logged-in member.
 * - is_admin: Flag for admin user status. Will be true when the current user
 *   is an administrator.
 *
 * @see template_preprocess_paragraph()
 *
 * @ingroup themeable
 */
#}
{%
  set classes = [
    'paragraph',
    'paragraph--type--' ~ paragraph.bundle|clean_class,
    view_mode ? 'paragraph--view-mode--' ~ view_mode|clean_class,
    not paragraph.isPublished() ? 'paragraph--unpublished'
  ]
%}
{% block paragraph %}
<section{{ attributes.addClass('text-block-section', 'py-5', 'ourPromiseWrapp') }}>
    <div class=\"ourPromise_top_curveline\">
        <img style=\"color:transparent;\" src=\"\\themes\\custom\\divihn_bootstrap\\images\\curve-outline-shape-zoom-top.209058c8.svg\" alt=\"TopCurveLine\" width=\"1920\" height=\"358\" loading=\"lazy\" decoding=\"async\" data-nimg=\"1\">
    </div>
  <div class=\"ourPromise\">
    {# Print the body field with WYSIWYG content #}
    <h2 class=\"sectionTitle lightBlue\">Our Promise</h2>
    <div class=\"headingBox\">
    <div class=\"text-bloc-body\">
      {{ content.field_text }}
    </div>

    {# Decorative curve at bottom #}
    <div class=\"text-bloc-curve\"></div>
  </div>
   </div>
      <div class=\"ourPromise_bottom_curveline\">
        <img style=\"color:transparent;\" src=\"\\themes\\custom\\divihn_bootstrap\\images\\curve-outline-shape-zoom-bottom.2b73c6c1.svg\" alt=\"BottomCurveLine\" width=\"1920\" height=\"704\" loading=\"lazy\" decoding=\"async\" data-nimg=\"1\">
    </div>
</section>
{% endblock paragraph %}
", "themes/custom/divihn_bootstrap/templates/paragraph/paragraph--text-block.html.twig", "/home/admin/public_html/dev.divihn2.com/my-drupal10-site/web/themes/custom/divihn_bootstrap/templates/paragraph/paragraph--text-block.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 42, "block" => 49];
        static $filters = ["clean_class" => 44, "escape" => 50];
        static $functions = [];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'block'],
                ['clean_class', 'escape'],
                [],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
