/**
 * @file
 * divihn_bootstrap behaviors.
 */
(function ($,Drupal, once) {
  'use strict';

  // Debugging
  Drupal.behaviors.divihnBootstrap = {
    attach(context, settings) {
      console.log('It works!');
    }
  };

  // AOS Init (no jQuery needed)
  Drupal.behaviors.aosInit = {
    attach: function (context, settings) {
      if (typeof AOS !== 'undefined') {
        once('aosInit', 'body', context).forEach(() => {
          AOS.init({
            once: true,
            duration: 500,
            easing: 'cubic-bezier(0.745, 0.065, 0.17, 1)',
          });
        });
      }
    }
  };
  
window.addEventListener("load", function () {

    const header = document.querySelector('header.site-header');
    const searchContainer = document.querySelector('#search-container');

    if (header && searchContainer) {

        // Move only if not already inside the header
        if (searchContainer.parentElement !== header) {

            header.appendChild(searchContainer);
        }

    } else {
        console.warn("⚠ header.site-header or #search-container not found");
    }

});
const searchInput = document.querySelector('header #search-container form input[name="search_api_fulltext"]');
const clearBtn = document.querySelector('header #search-container form .form-actions');

// Show button only when input has value
searchInput.addEventListener('input', () => {
    clearBtn.style.display = searchInput.value ? 'block' : 'none';
});

// Clear input + prevent form submit
clearBtn.addEventListener('click', (e) => {
    e.preventDefault();
    searchInput.value = '';
    clearBtn.style.display = 'none';
    searchInput.focus();
});

let footerToggleInitialized = false;

function enableFooterToggle() {
  const partsBlocks = document.querySelectorAll('.footerBox .parts');

  partsBlocks.forEach(function (partsBlock) {
    const headings = partsBlock.querySelectorAll('.heading');

    headings.forEach(function (heading) {
      heading.addEventListener('click', footerClickHandler);
    });
  });

  footerToggleInitialized = true;
}

//perspective filter start
let isMobileMode = false;
let searchItem = null;
let otherFields = null;

function setupMobileToggle() {
    const isNowMobile = window.innerWidth <= 1025;
    if (isNowMobile === isMobileMode) return;
    isMobileMode = isNowMobile;
    searchItem = document.querySelector(
        ".view-perspectives-search .view-filters form .js-form-item:first-child"
    );

    otherFields = document.querySelectorAll(
        ".view-perspectives-search .view-filters form .js-form-item:not(:first-child), .view-perspectives-search .view-filters form .form-actions"
    );

    if (!searchItem) return;

    if (isNowMobile) {
        otherFields.forEach(el => el.classList.add("hide-fields"));

        searchItem.addEventListener("click", mobileToggleHandler);
    }

    else {
        otherFields.forEach(el => el.classList.remove("hide-fields"));
        searchItem.removeEventListener("click", mobileToggleHandler);
    }
}

function mobileToggleHandler(event) {
    if (event.target.tagName !== "INPUT") {
        event.preventDefault();
    }

    otherFields.forEach(el => {
        el.classList.toggle("hide-fields");
    });
}

document.addEventListener("DOMContentLoaded", setupMobileToggle);

window.addEventListener("resize", setupMobileToggle);

//perspective filter end

function disableFooterToggle() {
  const partsBlocks = document.querySelectorAll('.footerBox .parts');

  partsBlocks.forEach(function (partsBlock) {
    const headings = partsBlock.querySelectorAll('.heading');

    // Remove event listeners
    headings.forEach(function (heading) {
      heading.removeEventListener('click', footerClickHandler);
    });

    // Remove active states
    partsBlock.querySelectorAll('.active').forEach(function (el) {
      el.classList.remove('active');
    });
  });

  footerToggleInitialized = false;
}

function footerClickHandler(e) {
  const heading = e.currentTarget;
  const parent = heading.closest('.part1, .part2, .parts');

  if (!parent) return;

  parent.classList.toggle('active');
}

function initFooterToggleMobile() {
  const isMobile = window.innerWidth <= 991;

  if (isMobile && !footerToggleInitialized) {
    enableFooterToggle();
  }

  if (!isMobile && footerToggleInitialized) {
    disableFooterToggle();
  }
}

initFooterToggleMobile();

window.addEventListener('resize', initFooterToggleMobile);

window.addEventListener('DOMContentLoaded', function () {
  var swipers = document.querySelectorAll('.swiper');

  swipers.forEach(function (swiper) {
    if (swiper.querySelector('#why-us')) {
      if (!swiper.parentElement.classList.contains('whyUsWrapp')) {
        var wrapper = document.createElement('div');
        wrapper.className = 'whyUsWrapp';
        swiper.parentNode.insertBefore(wrapper, swiper);
        wrapper.appendChild(swiper);
      }
    }
  });
});


//whatwedo_Card move on mobile script start
function moveCardsForMobile() {
  const firstFold = document.querySelector('.first-fold');
  const rightSide = firstFold ? firstFold.querySelector('.rightSide') : null;
  const secondFold = document.querySelector('.second-fold');
  const tabServices = secondFold ? secondFold.querySelector('#tab-services') : null;

  if (!rightSide || !tabServices) return;

  const serviceCards = rightSide.querySelectorAll('.services.card');
  const specialisationCards = rightSide.querySelectorAll('.specialisations.card');

  // Save original parent and nextSibling references (only once)
  if (!rightSide.dataset.initialized) {
    [...serviceCards, ...specialisationCards].forEach(card => {
      card.dataset.originalParent = card.parentNode ? card.parentNode.className : '';
      if (card.nextElementSibling) {
        card.dataset.nextSiblingSelector = '.' + card.nextElementSibling.className.split(' ').join('.');
      } else {
        card.dataset.nextSiblingSelector = 'null';
      }
    });
    rightSide.dataset.initialized = 'true';
  }

  if (window.innerWidth < 768) {
    // Move Services cards → prepend to #tab-services
    serviceCards.forEach(card => {
      if (!tabServices.contains(card)) {
        tabServices.insertBefore(card, tabServices.firstChild);
      }
    });

    // Move Specialisations cards → prepend to first specialisation card inside tabServices
    const firstSpec = tabServices.querySelector('.specialisations.card');
    if (firstSpec) {
      specialisationCards.forEach(card => {
        if (!tabServices.contains(card)) {
          tabServices.insertBefore(card, firstSpec);
        }
      });
    }
  } else {
    // Restore to original order in rightSide
    [...serviceCards, ...specialisationCards].forEach(card => {
      const nextSel = card.dataset.nextSiblingSelector;
      if (nextSel && nextSel !== 'null') {
        const nextSibling = rightSide.querySelector(nextSel);
        if (nextSibling) {
          rightSide.insertBefore(card, nextSibling);
        } else {
          rightSide.appendChild(card);
        }
      } else {
        rightSide.appendChild(card);
      }
    });
  }
}

function initCardMover() {
  moveCardsForMobile();
  window.addEventListener('resize', moveCardsForMobile);
}

document.addEventListener('DOMContentLoaded', initCardMover);



    // homepage banner slider mask animation start
  document.addEventListener("DOMContentLoaded", () => {
    const banner = document.querySelector(".paragraph--type--spotlight-banner");
    if (!banner) {
      return;
    }

    let isMasked = true;
    let lastScrollY = window.scrollY;

    // Initial state: show mask image
    banner.classList.add("maskAnimation");

    window.addEventListener("scroll", () => {
      const currentScrollY = window.scrollY;
      const rect = banner.getBoundingClientRect();
      const inViewport = rect.top < window.innerHeight && rect.bottom > 0;

      if (inViewport) {
        if (currentScrollY > lastScrollY && isMasked) {
          // Scrolling down → show real image
          banner.classList.add("maskAnimation");
          isMasked = false;
        } else if (currentScrollY < lastScrollY && !isMasked) {
          // Scrolling up → show mask image
          banner.classList.remove("maskAnimation");
          isMasked = true;
        }
      }

      lastScrollY = currentScrollY;
    });
  });

document.addEventListener("DOMContentLoaded", function () {

  const topCurve = document.querySelector(".testimonialNew_top_curveline");
  const bottomCurve = document.querySelector(".testimonialNew_bottom_curveline");
  const swiper = document.querySelector(".view-testimonial .swiper");

  if (!swiper) {
    return;
  }

  if (topCurve) {
    swiper.parentNode.insertBefore(topCurve, swiper);
  } else {
  }

  if (bottomCurve) {
    swiper.parentNode.insertBefore(bottomCurve, swiper.nextSibling);
  } else {
  }

});

  //Achievements section counter start
  function buildCounterDigits(number, container) {
    const numStr = number.toString();
    container.innerHTML = '';
    numStr.split('').forEach((char, index) => {
      const digitContainer = document.createElement('div');
      digitContainer.className = 'counter-digit';
      const ul = document.createElement('ul');
      if (char === '.' || char === '+') {
        const li = document.createElement('li');
        li.textContent = char;
        ul.appendChild(li);
      } else {
        for (let i = 0; i <= 9; i++) {
          const li = document.createElement('li');
          li.textContent = i;
          ul.appendChild(li);
        }
      }
      digitContainer.appendChild(ul);
      container.appendChild(digitContainer);
    });
  }
  function animateCounters() {
    document.querySelectorAll('.counter-block').forEach(block => {
      const target = block.getAttribute('data-number');
      const counter = block.querySelector('.counter');
      buildCounterDigits(target, counter);
      target.split('').forEach((char, index) => {
        const digit = counter.children[index];
        if (!digit) return;
        const ul = digit.querySelector('ul');
        if (char === '.' || char === '+') return;
        const value = parseInt(char);
        const offset = value * 50;
        setTimeout(() => {
          ul.style.transform = `translateY(-${offset}px)`;
        }, 100);
      });
    });
  }
  document.addEventListener("DOMContentLoaded", animateCounters);
 //Achievements section counter end

Drupal.behaviors.divihnColorbox = {
  attach: function (context, settings) {
    once('colorbox-inline', 'a.colorbox-inline', context).forEach(function (el) {
      $(el).colorbox({
        inline: true,
        width: '80%',
        maxWidth: '800px'
      });
    });
  }
};

//   Add this new behavior to handle autocomplete redirection explicitly
  Drupal.behaviors.autocompleteRedirect = {
    attach: function (context, settings) {
    //   Use 'once' to ensure this only attaches once per element
    //   Target your specific search input selector here. You may need to inspect
    //   your HTML to find the exact class or ID of the input field.
    //   Common selectors include:
    //   '.form-autocomplete', '.search-api-autocomplete-search-form', 
    //   '#edit-keys--2' (example ID), etc.
      
    //   I am using a common selector, please verify this in your browser DevTools:
      once('autocomplete-redirect', 'input.form-autocomplete', context).forEach(function (element) {
        $(element).autocomplete({
          // This overrides the default jQuery UI 'select' event
          select: function(event, ui) {
            // Find the first link (<a> tag) within the selected item's HTML
            // 'ui.item.value' contains the HTML snippet from the 'Display live results' response
            var url = $(ui.item.value).find('a').attr('href'); 
            
            if (url) {
              window.location.href = url; // Redirect the user immediately
              return false; // Prevent the default action (populating the box)
            }
          }
        });
      });
    once('autocomplete-redirect', 'input.form-autocomplete', context).forEach(function (element) {
  // Get the existing autocomplete instance attached by Search API Autocomplete
  var ac = $(element).data('ui-autocomplete');
  if (!ac) return;

  // Override its select event
  ac.options.select = function(event, ui) {
    var url = $(ui.item.value).find('a').attr('href');
    if (url) {
      window.location.href = url; // Redirect to the node
      return false; // Prevent default behavior
    }
  };
});

    }
  };

//who we serve trucation start
function truncateByCharacters() {
    const items = document.querySelectorAll(
        '.PublicSectorBoxWrapp .views-view-responsive-grid__item .views-field-field-description p'
    );

    items.forEach(function (p) {
        const fullText = p.innerText.trim();
        const limit = 230;

        if (fullText.length <= limit) return;

        p.setAttribute("data-full-text", fullText);

        const truncatedText = fullText.substring(0, limit) + "...";

        const readMoreSpan = document.createElement("span");
        readMoreSpan.classList.add("read-more-toggle");
        readMoreSpan.innerText = " Read more";
        p.innerText = truncatedText;
        p.appendChild(readMoreSpan);
        readMoreSpan.addEventListener("click", function () {
            if (p.classList.contains("expanded")) {
                p.classList.remove("expanded");
                p.innerText = truncatedText;
                p.appendChild(readMoreSpan);
                readMoreSpan.innerText = " Read more";
            } else {
                p.classList.add("expanded");
                p.innerText = fullText;
                p.appendChild(readMoreSpan);
                readMoreSpan.innerText = " Read less";
            }
        });
    });
}

document.addEventListener("DOMContentLoaded", truncateByCharacters);

//who we serve trucation end


  Drupal.behaviors.cardTabActivate = {
    attach: function (context) {
      once('cardTabActivate', 'body', context).forEach(() => {

        // Function to activate the tab by its hash
        function activateTabFromHash() {
          const hash = window.location.hash;
          if (!hash) return;

          const tabButton = document.querySelector(hash);
          if (!tabButton) return;

          // Activate the tab using Bootstrap Tab API
          if (bootstrap && bootstrap.Tab) {
            const tab = new bootstrap.Tab(tabButton);
            tab.show();
          }

          // Scroll to the tab section
          const tabContainer = tabButton.closest('.left-tabs-component');
          if (tabContainer) {
            tabContainer.scrollIntoView({ behavior: 'smooth', block: 'start' });
          }
        }

        // Activate on page load if hash exists
        if (window.location.hash) {
          activateTabFromHash();
        }

        // Activate on hashchange event (when the hash changes after a card click)
        window.addEventListener('hashchange', activateTabFromHash);

        // Handle card link click to update the URL and activate the tab
        document.querySelectorAll('.field__item a').forEach(link => {
          link.addEventListener('click', function (e) {
            e.preventDefault(); // Prevent page reload
            const hash = link.getAttribute('href');
            history.replaceState(null, null, hash); // Update the URL hash
            activateTabFromHash(); // Activate the tab based on the new hash
          });
        });

      });
    }
  };

})(jQuery, Drupal, once);

  // Landing page tab switching

(function ($) {
  $(document).ready(function () {
    // Function to switch tabs
    function switchTab(tab) {
      // Set active class on the clicked tab
      $('.second-fold .tab').removeClass('active');
      $('.second-fold .tab[data-tab="' + tab + '"]').addClass('active');

      // Show only cards for the selected tab in both folds
      $('.tab-card').hide();
      $('.tab-card[data-tab="' + tab + '"]').show();
    }

    // Initialize: show services cards, hide specialisations
    switchTab('services');

    // Tab click event
    $('.second-fold .tab').click(function (e) {
      e.preventDefault();
      var tab = $(this).data('tab');
      switchTab(tab);
    });
  });
})(jQuery);


(function (Drupal, once) {
  'use strict';

  // Arrow scroll for sticky nav tabs
  Drupal.behaviors.scrollableTabs = {
    attach(context, settings) {
      once('scrollable-tabs', '.tab-scroll-wrapper', context).forEach(function (container) {
        const wrapper = container.querySelector('.nav-scroll-wrapper');
        const leftArrow = container.querySelector('.left-arrow');
        const rightArrow = container.querySelector('.right-arrow');

        if (!wrapper || !leftArrow || !rightArrow) return;

        const scrollAmount = 150;

        function updateArrowVisibility() {
          const scrollLeft = wrapper.scrollLeft;
          const maxScrollLeft = wrapper.scrollWidth - wrapper.clientWidth;
          leftArrow.disabled = scrollLeft <= 0;
          rightArrow.disabled = scrollLeft >= maxScrollLeft - 1;
        }

        leftArrow.addEventListener('click', () => {
          wrapper.scrollBy({ left: -scrollAmount, behavior: 'smooth' });
        });

        rightArrow.addEventListener('click', () => {
          wrapper.scrollBy({ left: scrollAmount, behavior: 'smooth' });
        });

        wrapper.addEventListener('scroll', updateArrowVisibility);
        window.addEventListener('resize', updateArrowVisibility);

        updateArrowVisibility(); // Initial call
      });
    }
  };

 })(Drupal, once);
(function (Drupal, once, jQuery) {
  // Toggle search overlay
  Drupal.behaviors.searchToggle = {
    attach: function (context, settings) {
      once('searchToggle', '#search-toggle', context).forEach(function (el) {
        jQuery(el).on('click', function (e) {
          e.preventDefault();

          var $button = jQuery(this);
          var $container = jQuery('#search-container');
          var isExpanded = $button.attr('aria-expanded') === 'true';

          $button.attr('aria-expanded', !isExpanded);
          $container.toggleClass('d-none', isExpanded);

          $button.find('.search-icon').toggleClass('d-none', !isExpanded);
          $button.find('.close-icon').toggleClass('d-none', isExpanded);

          if (!isExpanded) {
            Drupal.attachBehaviors($container[0]);
            setTimeout(function () {
              $container.find('input[type="search"], input[type="text"]').first().trigger('focus');
            }, 100);
          }
        });
      });
    }
  };

// Drupal.behaviors.autocompleteRedirect = {
//   attach: function (context, settings) {
//     once('autocomplete-redirect', 'input.form-autocomplete', context).forEach(function (element) {
//       var ac = jQuery(element).data('ui-autocomplete');
//       if (!ac) return;

//       ac.options.select = function(event, ui) {
//         if (ui.item.path) {
//           window.location.href = ui.item.path; // redirect to node
//           return false; // prevent default autocomplete behavior
//         }
//         return true;
//       };
//     });
//   }
// };


})(Drupal, once, jQuery);
