(function ($) {
  "use strict";
  /**
   * Enable the colorbox inline functionality.
   */
  Drupal.behaviors.colorboxInline = {
    attach: function (context, drupalSettings) {
      $(once('colorbox-inline-processed', '[data-colorbox-inline]', context)).each(function () {
        var $link = $(this),
          data = $link.data(),
          settings = $.extend({}, drupalSettings.colorbox, {
            href: false,
            inline: true
          }, {
            className: data.class,
            href: data.colorboxInline,
            width: data.width,
            height: data.height,
            rel: data.rel,
            open: false
          });

		// Hide the colorbox source after if it was hidden before use.
        if (!$(settings.href).filter(':visible')[0]) {
          settings.onCleanup = function($link) {
            $($link.cache.href).hide();
          }
        }

        $link.colorbox(settings);
        $link.click(function () {
         $($(this).data('colorboxInline')).show();
         $(this).colorbox();
        });
      });
    }
  };
})(jQuery);
