<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* themes/custom/divihn_bootstrap/templates/page/page.html.twig */
class __TwigTemplate_386745cb281d9be05083f3d3ada80028 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'head' => [$this, 'block_head'],
            'content' => [$this, 'block_content'],
            'footer' => [$this, 'block_footer'],
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 71
        $context["sidebar_first_exists"] =  !Twig\Extension\CoreExtension::testEmpty(Twig\Extension\CoreExtension::trim(Twig\Extension\CoreExtension::striptags($this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "sidebar_first", [], "any", false, false, true, 71)), "<img><video><audio><drupal-render-placeholder>")));
        // line 72
        $context["sidebar_second_exists"] =  !Twig\Extension\CoreExtension::testEmpty(Twig\Extension\CoreExtension::trim(Twig\Extension\CoreExtension::striptags($this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "sidebar_second", [], "any", false, false, true, 72)), "<img><video><audio><drupal-render-placeholder>")));
        // line 73
        yield "
<div id=\"page-wrapper\">
  <div id=\"page\">

    ";
        // line 78
        yield "    <a href=\"#main-content\" class=\"visually-hidden focusable skip-link\">
      ";
        // line 79
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Skip to main content"));
        yield "
    </a>

    ";
        // line 82
        yield from $this->unwrap()->yieldBlock('head', $context, $blocks);
        // line 129
        yield "    <div id=\"main-wrapper\" class=\"layout-main-wrapper clearfix\">
      ";
        // line 130
        yield from $this->unwrap()->yieldBlock('content', $context, $blocks);
        // line 161
        yield "    </div>

    ";
        // line 163
        if (((CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "featured_bottom_first", [], "any", false, false, true, 163) || CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "featured_bottom_second", [], "any", false, false, true, 163)) || CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "featured_bottom_third", [], "any", false, false, true, 163))) {
            // line 164
            yield "      <div class=\"featured-bottom\">
        <aside class=\"";
            // line 165
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["container"] ?? null), "html", null, true);
            yield " clearfix\" role=\"complementary\" aria-label=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Featured bottom content"));
            yield "\">
          ";
            // line 166
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "featured_bottom_first", [], "any", false, false, true, 166), "html", null, true);
            yield "
          ";
            // line 167
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "featured_bottom_second", [], "any", false, false, true, 167), "html", null, true);
            yield "
          ";
            // line 168
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "featured_bottom_third", [], "any", false, false, true, 168), "html", null, true);
            yield "
        </aside>
      </div>
    ";
        }
        // line 172
        yield "
    <footer class=\"site-footer\" role=\"contentinfo\" aria-label=\"";
        // line 173
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Site footer"));
        yield "\">
      ";
        // line 174
        yield from $this->unwrap()->yieldBlock('footer', $context, $blocks);
        // line 191
        yield "    </footer>

  </div>
</div>";
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["page", "container", "navbar_top_attributes", "container_navbar", "content_attributes", "sidebar_first_attributes", "sidebar_second_attributes"]);        yield from [];
    }

    // line 82
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_head(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 83
        yield "      ";
        if (((CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "secondary_menu", [], "any", false, false, true, 83) || CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "top_header", [], "any", false, false, true, 83)) || CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "top_header_form", [], "any", false, false, true, 83))) {
            // line 84
            yield "        <nav";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["navbar_top_attributes"] ?? null), "html", null, true);
            yield " role=\"navigation\" aria-label=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Secondary menu"));
            yield "\">
          ";
            // line 85
            if (($context["container_navbar"] ?? null)) {
                // line 86
                yield "            <div class=\"container\">
          ";
            }
            // line 88
            yield "            ";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "secondary_menu", [], "any", false, false, true, 88), "html", null, true);
            yield "
            ";
            // line 89
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "top_header", [], "any", false, false, true, 89), "html", null, true);
            yield "
            ";
            // line 90
            if (CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "top_header_form", [], "any", false, false, true, 90)) {
                // line 91
                yield "              <div class=\"form-inline navbar-form ms-auto\" role=\"search\" aria-label=\"";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Site search"));
                yield "\">
                ";
                // line 92
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "top_header_form", [], "any", false, false, true, 92), "html", null, true);
                yield "
              </div>
            ";
            }
            // line 95
            yield "          ";
            if (($context["container_navbar"] ?? null)) {
                // line 96
                yield "            </div>
          ";
            }
            // line 98
            yield "        </nav>
      ";
        }
        // line 100
        yield "
      ";
        // line 101
        if (((CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "header", [], "any", false, false, true, 101) || CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "primary_menu", [], "any", false, false, true, 101)) || CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "header_actions", [], "any", false, false, true, 101))) {
            // line 102
            yield "        <header id=\"header\" class=\"site-header\" role=\"banner\" aria-label=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Site header"));
            yield "\">
          <div class=\"container header-container\">

            <div class=\"header-logo\">
              ";
            // line 106
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "header", [], "any", false, false, true, 106), "html", null, true);
            yield "
            </div>

            ";
            // line 109
            if (CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "primary_menu", [], "any", false, false, true, 109)) {
                // line 110
                yield "              <nav class=\"header-menu\" role=\"navigation\" aria-label=\"";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Primary menu"));
                yield "\">
                <ul class=\"navbar navbar-expand-lg\">
                  ";
                // line 112
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "primary_menu", [], "any", false, false, true, 112), "html", null, true);
                yield "
                </ul>
              </nav>
            ";
            }
            // line 116
            yield "
            ";
            // line 117
            if (CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "header_actions", [], "any", false, false, true, 117)) {
                // line 118
                yield "              <div class=\"header-actions ms-auto\" data-aos=\"fade-left\" data-aos-delay=\"400\">
                <div class=\"action-item\">
                  ";
                // line 120
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "header_actions", [], "any", false, false, true, 120), "html", null, true);
                yield "
                </div>
              </div>
            ";
            }
            // line 124
            yield "
          </div>
        </header>
      ";
        }
        // line 128
        yield "    ";
        yield from [];
    }

    // line 130
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 131
        yield "        <div id=\"main\" class=\"container-fluid\">

          <div class=\"row row-offcanvas row-offcanvas-left clearfix\">

            ";
        // line 136
        yield "            <main";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["content_attributes"] ?? null), "addClass", ["site-main"], "method", false, false, true, 136), "html", null, true);
        yield " role=\"main\" id=\"main-content\">
              <section class=\"section\">
                ";
        // line 138
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "content", [], "any", false, false, true, 138), "html", null, true);
        yield "
              </section>
            </main>

            ";
        // line 142
        if (($context["sidebar_first_exists"] ?? null)) {
            // line 143
            yield "              <aside";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["sidebar_first_attributes"] ?? null), "addClass", ["sidebar-first"], "method", false, false, true, 143), "html", null, true);
            yield " role=\"complementary\" aria-label=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("First sidebar"));
            yield "\">
                <div class=\"section\">
                  ";
            // line 145
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "sidebar_first", [], "any", false, false, true, 145), "html", null, true);
            yield "
                </div>
              </aside>
            ";
        }
        // line 149
        yield "
            ";
        // line 150
        if (($context["sidebar_second_exists"] ?? null)) {
            // line 151
            yield "              <aside";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["sidebar_second_attributes"] ?? null), "addClass", ["sidebar-second"], "method", false, false, true, 151), "html", null, true);
            yield " role=\"complementary\" aria-label=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Second sidebar"));
            yield "\">
                <div class=\"section\">
                  ";
            // line 153
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "sidebar_second", [], "any", false, false, true, 153), "html", null, true);
            yield "
                </div>
              </aside>
            ";
        }
        // line 157
        yield "
          </div>
        </div>
      ";
        yield from [];
    }

    // line 174
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_footer(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 175
        yield "        <div class=\"container-fluid\">
          ";
        // line 176
        if ((((CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "footer_first", [], "any", false, false, true, 176) || CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "footer_second", [], "any", false, false, true, 176)) || CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "footer_third", [], "any", false, false, true, 176)) || CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "footer_fourth", [], "any", false, false, true, 176))) {
            // line 177
            yield "            <div class=\"site-footer__top clearfix row\">
              ";
            // line 178
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "footer_first", [], "any", false, false, true, 178), "html", null, true);
            yield "
              ";
            // line 179
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "footer_second", [], "any", false, false, true, 179), "html", null, true);
            yield "
              ";
            // line 180
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "footer_third", [], "any", false, false, true, 180), "html", null, true);
            yield "
              ";
            // line 181
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "footer_fourth", [], "any", false, false, true, 181), "html", null, true);
            yield "
            </div>
          ";
        }
        // line 184
        yield "          ";
        if (CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "footer_fifth", [], "any", false, false, true, 184)) {
            // line 185
            yield "            <div class=\"site-footer__bottom row\">
              ";
            // line 186
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["page"] ?? null), "footer_fifth", [], "any", false, false, true, 186), "html", null, true);
            yield "
            </div>
          ";
        }
        // line 189
        yield "        </div>
      ";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "themes/custom/divihn_bootstrap/templates/page/page.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  354 => 189,  348 => 186,  345 => 185,  342 => 184,  336 => 181,  332 => 180,  328 => 179,  324 => 178,  321 => 177,  319 => 176,  316 => 175,  309 => 174,  301 => 157,  294 => 153,  286 => 151,  284 => 150,  281 => 149,  274 => 145,  266 => 143,  264 => 142,  257 => 138,  251 => 136,  245 => 131,  238 => 130,  233 => 128,  227 => 124,  220 => 120,  216 => 118,  214 => 117,  211 => 116,  204 => 112,  198 => 110,  196 => 109,  190 => 106,  182 => 102,  180 => 101,  177 => 100,  173 => 98,  169 => 96,  166 => 95,  160 => 92,  155 => 91,  153 => 90,  149 => 89,  144 => 88,  140 => 86,  138 => 85,  131 => 84,  128 => 83,  121 => 82,  112 => 191,  110 => 174,  106 => 173,  103 => 172,  96 => 168,  92 => 167,  88 => 166,  82 => 165,  79 => 164,  77 => 163,  73 => 161,  71 => 130,  68 => 129,  66 => 82,  60 => 79,  57 => 78,  51 => 73,  49 => 72,  47 => 71,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
/**
 * @file
 * Bootstrap's theme implementation to display a single page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.html.twig template normally located in the
 * core/modules/system directory.
 *
 * Available variables:
 *
 * General utility variables:
 * - base_path: The base URL path of the Drupal installation. Will usually be
 *   \"/\" unless you have installed Drupal in a sub-directory.
 * - is_front: A flag indicating if the current page is the front page.
 * - logged_in: A flag indicating if the user is registered and signed in.
 * - is_admin: A flag indicating if the user has permission to access
 *   administration pages.
 *
 * Site identity:
 * - front_page: The URL of the front page. Use this instead of base_path when
 *   linking to the front page. This includes the language domain or prefix.
 * - logo: The url of the logo image, as defined in theme settings.
 * - site_name: The name of the site. This is empty when displaying the site
 *   name has been disabled in the theme settings.
 * - site_slogan: The slogan of the site. This is empty when displaying the site
 *   slogan has been disabled in theme settings.

 * Page content (in order of occurrence in the default page.html.twig):
 * - node: Fully loaded node, if there is an automatically-loaded node
 *   associated with the page and the node ID is the second argument in the
 *   page's path (e.g. node/12345 and node/12345/revisions, but not
 *   comment/reply/12345).
 *
 * Regions:
 * - page.top_header: Items for the top header region.
 * - page.top_header_form: Items for the top header form region.
 * - page.header: Items for the header region.
 * - page.header_form: Items for the header form region.
 * - page.highlighted: Items for the highlighted region.
 * - page.primary_menu: Items for the primary menu region.
 * - page.secondary_menu: Items for the secondary menu region.
 * - page.featured_top: Items for the featured top region.
 * - page.content: The main content of the current page.
 * - page.sidebar_first: Items for the first sidebar.
 * - page.sidebar_second: Items for the second sidebar.
 * - page.featured_bottom_first: Items for the first featured bottom region.
 * - page.featured_bottom_second: Items for the second featured bottom region.
 * - page.featured_bottom_third: Items for the third featured bottom region.
 * - page.footer_first: Items for the first footer column.
 * - page.footer_second: Items for the second footer column.
 * - page.footer_third: Items for the third footer column.
 * - page.footer_fourth: Items for the fourth footer column.
 * - page.footer_fifth: Items for the fifth footer column.
 * - page.breadcrumb: Items for the breadcrumb region.
 *
 * Theme variables:
 * - navbar_top_attributes: Items for the header region.
 * - navbar_attributes: Items for the header region.
 * - content_attributes: Items for the header region.
 * - sidebar_first_attributes: Items for the highlighted region.
 * - sidebar_second_attributes: Items for the primary menu region.
 * - sidebar_collapse: If the sidebar_first will collapse.
 *
 * @see template_preprocess_page()
 * @see bootstrap_preprocess_page()
 * @see html.html.twig
 */
#}
{# see https://www.drupal.org/project/drupal/issues/953034#comment-14192130 #}
{% set sidebar_first_exists = page.sidebar_first|render|striptags('<img><video><audio><drupal-render-placeholder>')|trim is not empty %}
{% set sidebar_second_exists = page.sidebar_second|render|striptags('<img><video><audio><drupal-render-placeholder>')|trim is not empty %}

<div id=\"page-wrapper\">
  <div id=\"page\">

    {# 🔹 Skip link for keyboard users #}
    <a href=\"#main-content\" class=\"visually-hidden focusable skip-link\">
      {{ 'Skip to main content'|t }}
    </a>

    {% block head %}
      {% if page.secondary_menu or page.top_header or page.top_header_form %}
        <nav{{ navbar_top_attributes }} role=\"navigation\" aria-label=\"{{ 'Secondary menu'|t }}\">
          {% if container_navbar %}
            <div class=\"container\">
          {% endif %}
            {{ page.secondary_menu }}
            {{ page.top_header }}
            {% if page.top_header_form %}
              <div class=\"form-inline navbar-form ms-auto\" role=\"search\" aria-label=\"{{ 'Site search'|t }}\">
                {{ page.top_header_form }}
              </div>
            {% endif %}
          {% if container_navbar %}
            </div>
          {% endif %}
        </nav>
      {% endif %}

      {% if page.header or page.primary_menu or page.header_actions %}
        <header id=\"header\" class=\"site-header\" role=\"banner\" aria-label=\"{{ 'Site header'|t }}\">
          <div class=\"container header-container\">

            <div class=\"header-logo\">
              {{ page.header }}
            </div>

            {% if page.primary_menu %}
              <nav class=\"header-menu\" role=\"navigation\" aria-label=\"{{ 'Primary menu'|t }}\">
                <ul class=\"navbar navbar-expand-lg\">
                  {{ page.primary_menu }}
                </ul>
              </nav>
            {% endif %}

            {% if page.header_actions %}
              <div class=\"header-actions ms-auto\" data-aos=\"fade-left\" data-aos-delay=\"400\">
                <div class=\"action-item\">
                  {{ page.header_actions }}
                </div>
              </div>
            {% endif %}

          </div>
        </header>
      {% endif %}
    {% endblock %}
    <div id=\"main-wrapper\" class=\"layout-main-wrapper clearfix\">
      {% block content %}
        <div id=\"main\" class=\"container-fluid\">

          <div class=\"row row-offcanvas row-offcanvas-left clearfix\">

            {# 🔹 Main content landmark #}
            <main{{ content_attributes.addClass('site-main') }} role=\"main\" id=\"main-content\">
              <section class=\"section\">
                {{ page.content }}
              </section>
            </main>

            {% if sidebar_first_exists %}
              <aside{{ sidebar_first_attributes.addClass('sidebar-first') }} role=\"complementary\" aria-label=\"{{ 'First sidebar'|t }}\">
                <div class=\"section\">
                  {{ page.sidebar_first }}
                </div>
              </aside>
            {% endif %}

            {% if sidebar_second_exists %}
              <aside{{ sidebar_second_attributes.addClass('sidebar-second') }} role=\"complementary\" aria-label=\"{{ 'Second sidebar'|t }}\">
                <div class=\"section\">
                  {{ page.sidebar_second }}
                </div>
              </aside>
            {% endif %}

          </div>
        </div>
      {% endblock %}
    </div>

    {% if page.featured_bottom_first or page.featured_bottom_second or page.featured_bottom_third %}
      <div class=\"featured-bottom\">
        <aside class=\"{{ container }} clearfix\" role=\"complementary\" aria-label=\"{{ 'Featured bottom content'|t }}\">
          {{ page.featured_bottom_first }}
          {{ page.featured_bottom_second }}
          {{ page.featured_bottom_third }}
        </aside>
      </div>
    {% endif %}

    <footer class=\"site-footer\" role=\"contentinfo\" aria-label=\"{{ 'Site footer'|t }}\">
      {% block footer %}
        <div class=\"container-fluid\">
          {% if page.footer_first or page.footer_second or page.footer_third or page.footer_fourth %}
            <div class=\"site-footer__top clearfix row\">
              {{ page.footer_first }}
              {{ page.footer_second }}
              {{ page.footer_third }}
              {{ page.footer_fourth }}
            </div>
          {% endif %}
          {% if page.footer_fifth %}
            <div class=\"site-footer__bottom row\">
              {{ page.footer_fifth }}
            </div>
          {% endif %}
        </div>
      {% endblock %}
    </footer>

  </div>
</div>", "themes/custom/divihn_bootstrap/templates/page/page.html.twig", "/home/admin/public_html/dev.divihn2.com/my-drupal10-site/web/themes/custom/divihn_bootstrap/templates/page/page.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 71, "block" => 82, "if" => 163];
        static $filters = ["trim" => 71, "striptags" => 71, "render" => 71, "t" => 79, "escape" => 165];
        static $functions = [];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'block', 'if'],
                ['trim', 'striptags', 'render', 't', 'escape'],
                [],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
