document.addEventListener('DOMContentLoaded', function () {
  const slides = document.querySelectorAll('.hero-slide');
  const dots = document.querySelectorAll('.nav-dots .dot');
  const prev = document.querySelector('.nav-prev');
  const next = document.querySelector('.nav-next');
  let current = 0;
  let autoSlideInterval;

  if (!slides.length) return; // Exit if no slides

  function showSlide(index) {
    if (index >= slides.length) index = 0;
    if (index < 0) index = slides.length - 1;
    slides.forEach(slide => slide.classList.remove('active'));
    dots.forEach(dot => dot.classList.remove('active'));
    slides[index].classList.add('active');
    dots[index].classList.add('active');
    current = index;
  }

  function startAutoSlide() {
    autoSlideInterval = setInterval(() => showSlide(current + 1), 6000);
  }

  function resetAutoSlide() {
    clearInterval(autoSlideInterval);
    startAutoSlide();
  }

  prev?.addEventListener('click', () => {
    showSlide(current - 1);
    resetAutoSlide();
  });

  next?.addEventListener('click', () => {
    showSlide(current + 1);
    resetAutoSlide();
  });

  dots.forEach((dot, idx) => dot.addEventListener('click', () => {
    showSlide(idx);
    resetAutoSlide();
  }));

  showSlide(current);
  startAutoSlide();
});
