<?php

namespace Drupal\article_navigation\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\node\Entity\Node;

/**
 * Provides a 'Previous / Next Featured Article' block.
 *
 * @Block(
 *   id = "featured_article_navigation_block",
 *   admin_label = @Translation("Featured Article Navigation Block"),
 *   category = @Translation("Custom")
 * )
 */
class FeaturedArticleNavigationBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
public function build() {
  $node = \Drupal::routeMatch()->getParameter('node');
  if (!$node || $node->bundle() !== 'featured_article') {
    return [];
  }

  $current_nid = $node->id();

  // Get previous article
  $prev_query = \Drupal::entityQuery('node')
    ->condition('type', 'featured_article')
    ->condition('nid', $current_nid, '<')
    ->sort('nid', 'DESC')
    ->range(0, 1)
    ->accessCheck(FALSE); // 👈 Fix applied here
  $prev_nids = $prev_query->execute();

  // Get next article
  $next_query = \Drupal::entityQuery('node')
    ->condition('type', 'featured_article')
    ->condition('nid', $current_nid, '>')
    ->sort('nid', 'ASC')
    ->range(0, 1)
    ->accessCheck(FALSE); // 👈 Fix applied here
  $next_nids = $next_query->execute();

  $prev_node = !empty($prev_nids) ? \Drupal\node\Entity\Node::load(reset($prev_nids)) : NULL;
  $next_node = !empty($next_nids) ? \Drupal\node\Entity\Node::load(reset($next_nids)) : NULL;

  return [
    '#theme' => 'featured_article_navigation',
    '#prev' => $prev_node ? [
      'title' => $prev_node->getTitle(),
      'url' => $prev_node->toUrl()->toString(),
    ] : NULL,
    '#next' => $next_node ? [
      'title' => $next_node->getTitle(),
      'url' => $next_node->toUrl()->toString(),
    ] : NULL,
    '#cache' => [
      'tags' => ['node_list'],
      'contexts' => ['url.path'],
    ],
  ];
}


}
