<?php

/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 9.1.9 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();

// Add 'css_class' column to block table.
$connection->schema()->addField(
  'block',
  'css_class',
  [
    'type' => 'varchar',
    'length' => 255,
    'not null' => TRUE,
    'default' => '',
    'description' => 'String containing the classes for the block.',
  ]
);
// Add block classes to two system main blocks. Skipping 'theme' condition means
// that we will update both seven and bartik blocks.
$connection->update('block')
  ->condition('module', 'system')
  ->condition('delta', 'main')
  ->fields(['css_class' => 'block-class__system system-main-block-class'])
  ->execute();

// Mark 'block_class' installed.
$connection->insert('system')
  ->fields([
    'filename',
    'name',
    'type',
    'owner',
    'status',
    'bootstrap',
    'schema_version',
    'weight',
    'info',
  ])
  ->values([
    'filename' => 'sites/all/modules/block_class/block_class.module',
    'name' => 'block_class',
    'type' => 'module',
    'owner' => '',
    'status' => '1',
    'bootstrap' => '0',
    'schema_version' => '7103',
    'weight' => '0',
    'info' => 'a:13:{s:4:"name";s:11:"Block Class";s:11:"description";s:39:"Allows assigning CSS classes to blocks.";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"block";}s:5:"files";a:1:{i:0;s:16:"block_class.test";}s:17:"test_dependencies";a:5:{i:0;s:7:"context";i:1;s:14:"features (2.x)";i:2;s:23:"features_extra:fe_block";i:3;s:10:"menu_block";i:4;s:5:"views";}s:7:"version";s:7:"7.x-2.4";s:7:"project";s:11:"block_class";s:9:"datestamp";s:10:"1532735885";s:5:"mtime";i:1532735885;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
  ])
  ->values([
    'filename' => 'sites/all/modules/block_class/tests/block_class_fe_block_test.module',
    'name' => 'block_class_fe_block_test',
    'type' => 'module',
    'owner' => '',
    'status' => '0',
    'bootstrap' => '0',
    'schema_version' => '-1',
    'weight' => '0',
    'info' => 'a:14:{s:4:"name";s:44:"Block Class FE Block Integration Test Helper";s:11:"description";s:99:"Helper module for testing the integration of Block Class with Features through the FE Block module.";s:4:"core";s:3:"7.x";s:7:"package";s:8:"Features";s:12:"dependencies";a:1:{i:0;s:8:"fe_block";}s:8:"features";a:2:{s:17:"fe_block_settings";a:1:{i:0;s:11:"user-online";}s:12:"features_api";a:1:{i:0;s:5:"api:2";}}s:6:"hidden";b:1;s:7:"version";s:7:"7.x-2.4";s:7:"project";s:11:"block_class";s:9:"datestamp";s:10:"1532735885";s:5:"mtime";i:1532735885;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
  ])
  ->execute();
