<?php

namespace Drupal\webform_element_block\Plugin\WebformElement;

use Drupal\Core\Block\BlockManagerInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Render\RendererInterface;
use Drupal\webform\Plugin\WebformElement\WebformMarkup;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a 'block' Webform element.
 *
 * @WebformElement(
 *   id = "webform_block_element",
 *   label = @Translation("Webform Block Element"),
 *   description = @Translation("Displays a Drupal block as a Webform field."),
 *   category = @Translation("Custom"),
 * )
 */
class WebformBlockElement extends WebformMarkup {

  /**
   * The block manager.
   */
  protected BlockManagerInterface $blockManager;

  /**
   * The renderer service.
   */
  protected RendererInterface $renderer;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {

    $instance = new static($configuration, $plugin_id, $plugin_definition);
    $instance->logger = $container->get('logger.factory')->get('webform');
    $instance->configFactory = $container->get('config.factory');
    $instance->moduleHandler = $container->get('module_handler');
    $instance->currentUser = $container->get('current_user');
    $instance->entityTypeManager = $container->get('entity_type.manager');
    $instance->elementInfo = $container->get('plugin.manager.element_info');
    $instance->elementManager = $container->get('plugin.manager.webform.element');
    $instance->tokenManager = $container->get('webform.token_manager');
    $instance->librariesManager = $container->get('webform.libraries_manager');
    $instance->blockManager = $container->get('plugin.manager.block');
    $instance->renderer = $container->get('renderer');

    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function prepare(array &$element, $webform_submission = NULL) {
    parent::prepare($element, $webform_submission);

    // Get the block ID from the element settings.
    if (!empty($element['#block_id'])) {
      $plugin_block = $this->blockManager->createInstance($element['#block_id'], []);
      $block_render_array = $plugin_block->build();

      // Embed the block's render array into the Webform element.
      $element['#markup'] = $this->renderer->render($block_render_array);
    }
  }

  /**
   * {@inheritdoc}
   */
  public function defineDefaultProperties() {
    return [
      'block_id' => '',
    ] + parent::defineDefaultProperties();
  }

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);
    $form['block_id'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Block ID'),
      '#description' => $this->t('Enter the machine name of the block to render.'),
      '#default_value' => $this->getDefaultProperty('block_id'),
    ];

    return $form;
  }

}
