/* @license GPL-2.0-or-later https://www.drupal.org/licensing/faq */
(function($,Drupal){Drupal.behaviors.aosInit={attach:function(context,settings){if(typeof AOS!=='undefined')AOS.init({once:true,duration:500,easing:'cubic-bezier(0.745, 0.065, 0.17, 1)'});}};})(jQuery,Drupal);;
(($,Drupal,{isTabbable})=>{$.extend($.expr[':'],{tabbable(element){Drupal.deprecationError({message:'The :tabbable selector is deprecated in Drupal 9.2.0 and will be removed in Drupal 11.0.0. Use the core/tabbable library instead. See https://www.drupal.org/node/3183730'});return isTabbable(element);}});})(jQuery,Drupal,window.tabbable);;
(($)=>{let cachedScrollbarWidth=null;const {max,abs}=Math;const regexHorizontal=/left|center|right/;const regexVertical=/top|center|bottom/;const regexOffset=/[+-]\d+(\.[\d]+)?%?/;const regexPosition=/^\w+/;const _position=$.fn.position;function getOffsets(offsets,width,height){return [parseFloat(offsets[0])*(typeof offsets[0]==='string'&&offsets[0].endsWith('%')?width/100:1),parseFloat(offsets[1])*(typeof offsets[1]==='string'&&offsets[1].endsWith('%')?height/100:1)];}function parseCss(element,property){return parseInt(window.getComputedStyle(element)[property],10)||0;}function getDimensions(elem){const raw=elem[0];if(raw.nodeType===9)return {width:elem.width(),height:elem.height(),offset:{top:0,left:0}};if(!!raw&&raw===raw.window)return {width:elem.width(),height:elem.height(),offset:{top:elem.scrollTop(),left:elem.scrollLeft()}};if(raw.preventDefault)return {width:0,height:0,offset:{top:raw.pageY,left:raw.pageX}};return {width:elem.outerWidth(),height:elem.outerHeight(),offset:elem.offset()};}const collisions={fit:{left(position,data){const {within}=data;const withinOffset=within.isWindow?within.scrollLeft:within.offset.left;const outerWidth=within.width;const collisionPosLeft=position.left-data.collisionPosition.marginLeft;const overLeft=withinOffset-collisionPosLeft;const overRight=collisionPosLeft+data.collisionWidth-outerWidth-withinOffset;let newOverRight;if(data.collisionWidth>outerWidth)if(overLeft>0&&overRight<=0){newOverRight=position.left+overLeft+data.collisionWidth-outerWidth-withinOffset;position.left+=overLeft-newOverRight;}else if(overRight>0&&overLeft<=0)position.left=withinOffset;else if(overLeft>overRight)position.left=withinOffset+outerWidth-data.collisionWidth;else position.left=withinOffset;else if(overLeft>0)position.left+=overLeft;else if(overRight>0)position.left-=overRight;else position.left=max(position.left-collisionPosLeft,position.left);},top(position,data){const {within}=data;const withinOffset=within.isWindow?within.scrollTop:within.offset.top;const outerHeight=data.within.height;const collisionPosTop=position.top-data.collisionPosition.marginTop;const overTop=withinOffset-collisionPosTop;const overBottom=collisionPosTop+data.collisionHeight-outerHeight-withinOffset;let newOverBottom;if(data.collisionHeight>outerHeight)if(overTop>0&&overBottom<=0){newOverBottom=position.top+overTop+data.collisionHeight-outerHeight-withinOffset;position.top+=overTop-newOverBottom;}else if(overBottom>0&&overTop<=0)position.top=withinOffset;else if(overTop>overBottom)position.top=withinOffset+outerHeight-data.collisionHeight;else position.top=withinOffset;else if(overTop>0)position.top+=overTop;else if(overBottom>0)position.top-=overBottom;else position.top=max(position.top-collisionPosTop,position.top);}},flip:{left(position,data){const {within}=data;const withinOffset=within.offset.left+within.scrollLeft;const outerWidth=within.width;const offsetLeft=within.isWindow?within.scrollLeft:within.offset.left;const collisionPosLeft=position.left-data.collisionPosition.marginLeft;const overLeft=collisionPosLeft-offsetLeft;const overRight=collisionPosLeft+data.collisionWidth-outerWidth-offsetLeft;const myOffset=data.my[0]==='left'?-data.elemWidth:data.my[0]==='right'?data.elemWidth:0;const atOffset=data.at[0]==='left'?data.targetWidth:data.at[0]==='right'?-data.targetWidth:0;const offset=-2*data.offset[0];let newOverRight;let newOverLeft;if(overLeft<0){newOverRight=position.left+myOffset+atOffset+offset+data.collisionWidth-outerWidth-withinOffset;if(newOverRight<0||newOverRight<abs(overLeft))position.left+=myOffset+atOffset+offset;}else{if(overRight>0){newOverLeft=position.left-data.collisionPosition.marginLeft+myOffset+atOffset+offset-offsetLeft;if(newOverLeft>0||abs(newOverLeft)<overRight)position.left+=myOffset+atOffset+offset;}}},top(position,data){const {within}=data;const withinOffset=within.offset.top+within.scrollTop;const outerHeight=within.height;const offsetTop=within.isWindow?within.scrollTop:within.offset.top;const collisionPosTop=position.top-data.collisionPosition.marginTop;const overTop=collisionPosTop-offsetTop;const overBottom=collisionPosTop+data.collisionHeight-outerHeight-offsetTop;const top=data.my[1]==='top';const myOffset=top?-data.elemHeight:data.my[1]==='bottom'?data.elemHeight:0;const atOffset=data.at[1]==='top'?data.targetHeight:data.at[1]==='bottom'?-data.targetHeight:0;const offset=-2*data.offset[1];let newOverTop;let newOverBottom;if(overTop<0){newOverBottom=position.top+myOffset+atOffset+offset+data.collisionHeight-outerHeight-withinOffset;if(newOverBottom<0||newOverBottom<abs(overTop))position.top+=myOffset+atOffset+offset;}else{if(overBottom>0){newOverTop=position.top-data.collisionPosition.marginTop+myOffset+atOffset+offset-offsetTop;if(newOverTop>0||abs(newOverTop)<overBottom)position.top+=myOffset+atOffset+offset;}}}},flipfit:{left(...args){collisions.flip.left.apply(this,args);collisions.fit.left.apply(this,args);},top(...args){collisions.flip.top.apply(this,args);collisions.fit.top.apply(this,args);}}};$.position={scrollbarWidth(){if(cachedScrollbarWidth!==undefined)return cachedScrollbarWidth;const div=$('<div '+"style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'>"+"<div style='height:100px;width:auto;'></div></div>");const innerDiv=div.children()[0];$('body').append(div);const w1=innerDiv.offsetWidth;div[0].style.overflow='scroll';let w2=innerDiv.offsetWidth;if(w1===w2)w2=div[0].clientWidth;div.remove();cachedScrollbarWidth=w1-w2;return cachedScrollbarWidth;},getScrollInfo(within){const overflowX=within.isWindow||within.isDocument?'':window.getComputedStyle(within.element[0])['overflow-x'];const overflowY=within.isWindow||within.isDocument?'':window.getComputedStyle(within.element[0])['overflow-y'];const hasOverflowX=overflowX==='scroll'||(overflowX==='auto'&&within.width<within.element[0].scrollWidth);const hasOverflowY=overflowY==='scroll'||(overflowY==='auto'&&within.height<within.element[0].scrollHeight);return {width:hasOverflowY?$.position.scrollbarWidth():0,height:hasOverflowX?$.position.scrollbarWidth():0};},getWithinInfo(element){const withinElement=$(element||window);const isWindow=!!withinElement[0]&&withinElement[0]===withinElement[0].window;const isDocument=!!withinElement[0]&&withinElement[0].nodeType===9;const hasOffset=!isWindow&&!isDocument;return {element:withinElement,isWindow,isDocument,offset:hasOffset?$(element).offset():{left:0,top:0},scrollLeft:withinElement.scrollLeft(),scrollTop:withinElement.scrollTop(),width:withinElement.outerWidth(),height:withinElement.outerHeight()};}};$.fn.position=function(options){if(!options||!options.of)return _position.apply(this,arguments);options=$.extend({},options);const within=$.position.getWithinInfo(options.within);const scrollInfo=$.position.getScrollInfo(within);const collision=(options.collision||'flip').split(' ');const offsets={};const target=typeof options.of==='string'?$(document).find(options.of):$(options.of);const dimensions=getDimensions(target);const targetWidth=dimensions.width;const targetHeight=dimensions.height;const targetOffset=dimensions.offset;if(target[0].preventDefault)options.at='left top';const basePosition=$.extend({},targetOffset);$.each(['my','at'],function(){let pos=(options[this]||'').split(' ');if(pos.length===1)pos=regexHorizontal.test(pos[0])?pos.concat(['center']):regexVertical.test(pos[0])?['center'].concat(pos):['center','center'];pos[0]=regexHorizontal.test(pos[0])?pos[0]:'center';pos[1]=regexVertical.test(pos[1])?pos[1]:'center';const horizontalOffset=regexOffset.exec(pos[0]);const verticalOffset=regexOffset.exec(pos[1]);offsets[this]=[horizontalOffset?horizontalOffset[0]:0,verticalOffset?verticalOffset[0]:0];options[this]=[regexPosition.exec(pos[0])[0],regexPosition.exec(pos[1])[0]];});if(collision.length===1)collision[1]=collision[0];if(options.at[0]==='right')basePosition.left+=targetWidth;else{if(options.at[0]==='center')basePosition.left+=targetWidth/2;}if(options.at[1]==='bottom')basePosition.top+=targetHeight;else{if(options.at[1]==='center')basePosition.top+=targetHeight/2;}const atOffset=getOffsets(offsets.at,targetWidth,targetHeight);basePosition.left+=atOffset[0];basePosition.top+=atOffset[1];return this.each(function(){let using;const elem=$(this);const elemWidth=elem.outerWidth();const elemHeight=elem.outerHeight();const marginLeft=parseCss(this,'marginLeft');const marginTop=parseCss(this,'marginTop');const collisionWidth=elemWidth+marginLeft+parseCss(this,'marginRight')+scrollInfo.width;const collisionHeight=elemHeight+marginTop+parseCss(this,'marginBottom')+scrollInfo.height;const position=$.extend({},basePosition);const myOffset=getOffsets(offsets.my,elem.outerWidth(),elem.outerHeight());if(options.my[0]==='right')position.left-=elemWidth;else{if(options.my[0]==='center')position.left-=elemWidth/2;}if(options.my[1]==='bottom')position.top-=elemHeight;else{if(options.my[1]==='center')position.top-=elemHeight/2;}position.left+=myOffset[0];position.top+=myOffset[1];const collisionPosition={marginLeft,marginTop};$.each(['left','top'],function(i,dir){if(collisions[collision[i]])collisions[collision[i]][dir](position,{targetWidth,targetHeight,elemWidth,elemHeight,collisionPosition,collisionWidth,collisionHeight,offset:[atOffset[0]+myOffset[0],atOffset[1]+myOffset[1]],my:options.my,at:options.at,within,elem});});if(options.using)using=function(props){const left=targetOffset.left-position.left;const right=left+targetWidth-elemWidth;const top=targetOffset.top-position.top;const bottom=top+targetHeight-elemHeight;const feedback={target:{element:target,left:targetOffset.left,top:targetOffset.top,width:targetWidth,height:targetHeight},element:{element:elem,left:position.left,top:position.top,width:elemWidth,height:elemHeight},horizontal:right<0?'left':left>0?'right':'center',vertical:bottom<0?'top':top>0?'bottom':'middle'};if(targetWidth<elemWidth&&abs(left+right)<targetWidth)feedback.horizontal='center';if(targetHeight<elemHeight&&abs(top+bottom)<targetHeight)feedback.vertical='middle';if(max(abs(left),abs(right))>max(abs(top),abs(bottom)))feedback.important='horizontal';else feedback.important='vertical';options.using.call(this,props,feedback);};elem.offset($.extend(position,{using}));});};if(!$.hasOwnProperty('ui'))$.ui={};$.ui.position=collisions;})(jQuery);;
(function($,Drupal,once){if(once('drupal-dialog-deprecation-listener','html').length){const eventSpecial={handle($event){const $element=$($event.target);const event=$event.originalEvent;const dialog=event.dialog;const dialogArguments=[$event,dialog,$element,event?.settings];$event.handleObj.handler.apply(this,dialogArguments);}};$.event.special['dialog:beforecreate']=eventSpecial;$.event.special['dialog:aftercreate']=eventSpecial;$.event.special['dialog:beforeclose']=eventSpecial;$.event.special['dialog:afterclose']=eventSpecial;const listenDialogEvent=(event)=>{const windowEvents=$._data(window,'events');const isWindowHasDialogListener=windowEvents[event.type];if(isWindowHasDialogListener)Drupal.deprecationError({message:`jQuery event ${event.type} is deprecated in 10.3.0 and is removed from Drupal:12.0.0. See https://www.drupal.org/node/3422670`});};['dialog:beforecreate','dialog:aftercreate','dialog:beforeclose','dialog:afterclose'].forEach((e)=>window.addEventListener(e,listenDialogEvent));}})(jQuery,Drupal,once);;
class DrupalDialogEvent extends Event{constructor(type,dialog,settings=null){super(`dialog:${type}`,{bubbles:true});this.dialog=dialog;this.settings=settings;}}(function($,Drupal,drupalSettings,bodyScrollLock){drupalSettings.dialog={autoOpen:true,dialogClass:'',buttonClass:'button',buttonPrimaryClass:'button--primary',close(event){Drupal.dialog(event.target).close();Drupal.detachBehaviors(event.target,null,'unload');}};Drupal.dialog=function(element,options){let undef;const $element=$(element);const domElement=$element.get(0);const dialog={open:false,returnValue:undef};function openDialog(settings){settings=$.extend({},drupalSettings.dialog,options,settings);const event=new DrupalDialogEvent('beforecreate',dialog,settings);domElement.dispatchEvent(event);$element.dialog(event.settings);dialog.open=true;if(event.settings.modal)bodyScrollLock.lock(domElement);domElement.dispatchEvent(new DrupalDialogEvent('aftercreate',dialog,event.settings));}function closeDialog(value){domElement.dispatchEvent(new DrupalDialogEvent('beforeclose',dialog));bodyScrollLock.clearBodyLocks();$element.dialog('close');dialog.returnValue=value;dialog.open=false;domElement.dispatchEvent(new DrupalDialogEvent('afterclose',dialog));}dialog.show=()=>{openDialog({modal:false});};dialog.showModal=()=>{openDialog({modal:true});};dialog.close=closeDialog;return dialog;};})(jQuery,Drupal,drupalSettings,bodyScrollLock);;
(function($,Drupal,drupalSettings,debounce,displace){drupalSettings.dialog=$.extend({autoResize:true,maxHeight:'95%'},drupalSettings.dialog);function resetPosition(options){const offsets=displace.offsets;const left=offsets.left-offsets.right;const top=offsets.top-offsets.bottom;const leftString=`${(left>0?'+':'-')+Math.abs(Math.round(left/2))}px`;const topString=`${(top>0?'+':'-')+Math.abs(Math.round(top/2))}px`;options.position={my:`center${left!==0?leftString:''} center${top!==0?topString:''}`,of:window};return options;}function resetSize(event){const positionOptions=['width','height','minWidth','minHeight','maxHeight','maxWidth','position'];let adjustedOptions={};let windowHeight=$(window).height();let option;let optionValue;let adjustedValue;for(let n=0;n<positionOptions.length;n++){option=positionOptions[n];optionValue=event.data.settings[option];if(optionValue)if(typeof optionValue==='string'&&optionValue.endsWith('%')&&/height/i.test(option)){windowHeight-=displace.offsets.top+displace.offsets.bottom;adjustedValue=parseInt(0.01*parseInt(optionValue,10)*windowHeight,10);if(option==='height'&&Math.round(event.data.$element.parent().outerHeight())<adjustedValue)adjustedValue='auto';adjustedOptions[option]=adjustedValue;}}if(!event.data.settings.modal)adjustedOptions=resetPosition(adjustedOptions);event.data.$element.dialog('option',adjustedOptions);event.data.$element?.get(0)?.dispatchEvent(new CustomEvent('dialogContentResize',{bubbles:true}));}window.addEventListener('dialog:aftercreate',(e)=>{const autoResize=debounce(resetSize,20);const $element=$(e.target);const {settings}=e;const eventData={settings,$element};if(settings.autoResize===true||settings.autoResize==='true'){const uiDialog=$element.dialog('option',{resizable:false,draggable:false}).dialog('widget');uiDialog[0].style.position='fixed';$(window).on('resize.dialogResize scroll.dialogResize',eventData,autoResize).trigger('resize.dialogResize');$(document).on('drupalViewportOffsetChange.dialogResize',eventData,autoResize);}});window.addEventListener('dialog:beforeclose',()=>{$(window).off('.dialogResize');$(document).off('.dialogResize');});})(jQuery,Drupal,drupalSettings,Drupal.debounce,Drupal.displace);;
(function($,{tabbable,isTabbable}){$.widget('ui.dialog',$.ui.dialog,{options:{buttonClass:'button',buttonPrimaryClass:'button--primary'},_createButtons(){const opts=this.options;let primaryIndex;let index;const il=opts.buttons.length;for(index=0;index<il;index++)if(opts.buttons[index].primary&&opts.buttons[index].primary===true){primaryIndex=index;delete opts.buttons[index].primary;break;}this._super();const $buttons=this.uiButtonSet.children().addClass(opts.buttonClass);if(typeof primaryIndex!=='undefined')$buttons.eq(index).addClass(opts.buttonPrimaryClass);},_focusTabbable(){let hasFocus=this._focusedElement?this._focusedElement.get(0):null;if(!hasFocus)hasFocus=this.element.find('[autofocus]').get(0);if(!hasFocus){const $elements=[this.element,this.uiDialogButtonPane];for(let i=0;i<$elements.length;i++){const element=$elements[i].get(0);if(element){const elementTabbable=tabbable(element);hasFocus=elementTabbable.length?elementTabbable[0]:null;}if(hasFocus)break;}}if(!hasFocus){const closeBtn=this.uiDialogTitlebarClose.get(0);hasFocus=closeBtn&&isTabbable(closeBtn)?closeBtn:null;}if(!hasFocus)hasFocus=this.uiDialog.get(0);$(hasFocus).eq(0).trigger('focus');}});})(jQuery,window.tabbable);;
(($)=>{$.widget('ui.dialog',$.ui.dialog,{_allowInteraction(event){if(event.target.classList===undefined)return this._super(event);return event.target.classList.contains('ck')||this._super(event);}});})(jQuery);;
(function($,Drupal,debounce){$.fn.drupalGetSummary=function(){const callback=this.data('summaryCallback');if(!this[0]||!callback)return '';const result=callback(this[0]);return result?result.trim():'';};$.fn.drupalSetSummary=function(callback){const self=this;if(typeof callback!=='function'){const val=callback;callback=function(){return val;};}return (this.data('summaryCallback',callback).off('formUpdated.summary').on('formUpdated.summary',()=>{self.trigger('summaryUpdated');}).trigger('summaryUpdated'));};Drupal.behaviors.formSingleSubmit={attach(){function onFormSubmit(e){const $form=$(e.currentTarget);const formValues=new URLSearchParams(new FormData(e.target)).toString();const previousValues=$form.attr('data-drupal-form-submit-last');if(previousValues===formValues)e.preventDefault();else $form.attr('data-drupal-form-submit-last',formValues);}$(once('form-single-submit','body')).on('submit.singleSubmit','form:not([method~="GET"])',onFormSubmit);}};function triggerFormUpdated(element){$(element).trigger('formUpdated');}function fieldsList(form){return [].map.call(form.querySelectorAll('[name][id]'),(el)=>el.id);}Drupal.behaviors.formUpdated={attach(context){const $context=$(context);const contextIsForm=context.tagName==='FORM';const $forms=$(once('form-updated',contextIsForm?$context:$context.find('form')));let formFields;if($forms.length)$.makeArray($forms).forEach((form)=>{const events='change.formUpdated input.formUpdated ';const eventHandler=debounce((event)=>{triggerFormUpdated(event.target);},300);formFields=fieldsList(form).join(',');form.setAttribute('data-drupal-form-fields',formFields);$(form).on(events,eventHandler);});if(contextIsForm){formFields=fieldsList(context).join(',');const currentFields=$(context).attr('data-drupal-form-fields');if(formFields!==currentFields)triggerFormUpdated(context);}},detach(context,settings,trigger){const $context=$(context);const contextIsForm=context.tagName==='FORM';if(trigger==='unload')once.remove('form-updated',contextIsForm?$context:$context.find('form')).forEach((form)=>{form.removeAttribute('data-drupal-form-fields');$(form).off('.formUpdated');});}};Drupal.behaviors.fillUserInfoFromBrowser={attach(context,settings){const userInfo=['name','mail','homepage'];const $forms=$(once('user-info-from-browser','[data-user-info-from-browser]'));if($forms.length)userInfo.forEach((info)=>{const $element=$forms.find(`[name=${info}]`);const browserData=localStorage.getItem(`Drupal.visitor.${info}`);if(!$element.length)return;const emptyValue=$element[0].value==='';const defaultValue=$element.attr('data-drupal-default-value')===$element[0].value;if(browserData&&(emptyValue||defaultValue))$element.each(function(index,item){item.value=browserData;});});$forms.on('submit',()=>{userInfo.forEach((info)=>{const $element=$forms.find(`[name=${info}]`);if($element.length)localStorage.setItem(`Drupal.visitor.${info}`,$element[0].value);});});}};const handleFragmentLinkClickOrHashChange=(e)=>{let url;if(e.type==='click')url=e.currentTarget.location?e.currentTarget.location:e.currentTarget;else url=window.location;const hash=url.hash.substring(1);if(hash){const $target=$(`#${hash}`);$('body').trigger('formFragmentLinkClickOrHashChange',[$target]);setTimeout(()=>$target.trigger('focus'),300);}};const debouncedHandleFragmentLinkClickOrHashChange=debounce(handleFragmentLinkClickOrHashChange,300,true);$(window).on('hashchange.form-fragment',debouncedHandleFragmentLinkClickOrHashChange);$(document).on('click.form-fragment','a[href*="#"]',debouncedHandleFragmentLinkClickOrHashChange);})(jQuery,Drupal,Drupal.debounce);;
(function($,Drupal){Drupal.behaviors.nodePreviewDestroyLinks={attach(context){function clickPreviewModal(event){if(event.button===0&&!event.altKey&&!event.ctrlKey&&!event.metaKey&&!event.shiftKey){event.preventDefault();const $previewDialog=$(`<div>${Drupal.theme('nodePreviewModal')}</div>`).appendTo('body');Drupal.dialog($previewDialog,{title:Drupal.t('Leave preview?'),buttons:[{text:Drupal.t('Cancel'),click(){$(this).dialog('close');}},{text:Drupal.t('Leave preview'),click(){window.top.location.href=event.currentTarget.href;}}]}).showModal();}}if(!context.querySelector('.node-preview-container'))return;if(once('node-preview','html').length)$(document).on('click.preview','a:not([href^="#"], .node-preview-container a)',clickPreviewModal);},detach(context,settings,trigger){if(trigger==='unload')if(context.querySelector('.node-preview-container')&&once.remove('node-preview','html').length)$(document).off('click.preview');}};Drupal.behaviors.nodePreviewSwitchViewMode={attach(context){const autosubmit=once('autosubmit','[data-drupal-autosubmit]',context);if(autosubmit.length)$(autosubmit).on('formUpdated.preview',function(){$(this.form).trigger('submit');});}};Drupal.theme.nodePreviewModal=function(){return `<p>${Drupal.t('Leaving the preview will cause unsaved changes to be lost. Are you sure you want to leave the preview?')}</p><small class="description">${Drupal.t('CTRL+Left click will prevent this dialog from showing and proceed to the clicked link.')}</small>`;};})(jQuery,Drupal);;
(function($,Drupal,drupalSettings){const pathInfo=drupalSettings.path;const escapeAdminPath=sessionStorage.getItem('escapeAdminPath');const windowLocation=window.location;if(!pathInfo.currentPathIsAdmin&&!/destination=/.test(windowLocation.search))sessionStorage.setItem('escapeAdminPath',windowLocation);Drupal.behaviors.escapeAdmin={attach(){const toolbarEscape=once('escapeAdmin','[data-toolbar-escape-admin]');if(toolbarEscape.length&&pathInfo.currentPathIsAdmin&&escapeAdminPath!==null)$(toolbarEscape).attr('href',escapeAdminPath);}};})(jQuery,Drupal,drupalSettings);;
(function($,once){'use strict';$(document).on('click','.contextual',function(){$(once('webform-contextual','a.webform-contextual',this)).each(function(){this.href=this.href.split('?')[0];if(/webform\/([^/]+)\/test$/.test(this.href))this.href=window.location.pathname+'?_webform_test='+RegExp.$1;});});})(jQuery,once);;
(function($,Drupal,once){'use strict';var hasLocalStorage=(function(){try{localStorage.setItem('webform','webform');localStorage.removeItem('webform');return true;}catch(e){return false;}}());Drupal.behaviors.webformDetailsSave={attach:function(context){if(!hasLocalStorage)return;$(once('webform-details-summary-save','details > summary',context)).on('click',function(){var $details=$(this).parent();if($details[0].hasAttribute('data-webform-details-nosave'))return;var name=Drupal.webformDetailsSaveGetName($details);if(!name)return;var open=($details.attr('open')!=='open')?'1':'0';localStorage.setItem(name,open);});$(once('webform-details-save','details',context)).each(function(){var $details=$(this);var name=Drupal.webformDetailsSaveGetName($details);if(!name)return;var open=localStorage.getItem(name);if(open===null)return;if(open==='1')$details.attr('open','open');else $details.removeAttr('open');});}};Drupal.webformDetailsSaveGetName=function($details){if(!hasLocalStorage)return '';if($details.hasClass('vertical-tabs__pane'))return '';var webformId=$details.attr('data-webform-element-id');if(webformId)return 'Drupal.webform.'+webformId.replace('--','.');var detailsId=$details.attr('id');if(!detailsId)return '';var $form=$details.parents('form');if(!$form.length||!$form.attr('id'))return '';var formId=$form.attr('id');if(!formId)return '';formId=formId.replace(/--.+?$/,'').replace(/-/g,'_');detailsId=detailsId.replace(/--.+?$/,'').replace(/-/g,'_');return 'Drupal.webform.'+formId+'.'+detailsId;};})(jQuery,Drupal,once);;
(function($,Drupal,once){'use strict';Drupal.webform=Drupal.webform||{};Drupal.webform.detailsToggle=Drupal.webform.detailsToggle||{};Drupal.webform.detailsToggle.options=Drupal.webform.detailsToggle.options||{};Drupal.behaviors.webformDetailsToggle={attach:function(context){$(once('webform-details-toggle','.js-webform-details-toggle',context)).each(function(){var $form=$(this);var $tabs=$form.find('.webform-tabs');var selector=($tabs.length)?'.webform-tab':'.js-webform-details-toggle, .webform-elements';var $details=$form.find('details').filter(function(){var $parents=$(this).parentsUntil(selector);return ($parents.find('details').length===0);});if($details.length<2)return;var options=$.extend({button:'<button type="button" class="webform-details-toggle-state"></button>'},Drupal.webform.detailsToggle.options);var $toggle=$(options.button).attr('title',Drupal.t('Toggle details widget state.')).on('click',function(e){var $details=$form.find('details:not(.vertical-tabs__pane)');var $summary=$details.find('summary');var open;if(Drupal.webform.detailsToggle.isFormDetailsOpen($form)){$details.removeAttr('open');$summary.attr('aria-expanded','false');open=0;}else{$details.attr('open','open');$summary.attr('aria-expanded','true');open=1;}Drupal.webform.detailsToggle.setDetailsToggleLabel($form);if(Drupal.webformDetailsSaveGetName)$details.each(function(){var name=Drupal.webformDetailsSaveGetName($(this));if(name)localStorage.setItem(name,open);});}).wrap('<div class="webform-details-toggle-state-wrapper"></div>').parent();if($tabs.length)$tabs.find('.item-list:first-child').eq(0).before($toggle);else $details.eq(0).before($toggle);Drupal.webform.detailsToggle.setDetailsToggleLabel($form);});}};Drupal.webform.detailsToggle.isFormDetailsOpen=function($form){return ($form.find('details[open]').length===$form.find('details').length);};Drupal.webform.detailsToggle.setDetailsToggleLabel=function($form){var isOpen=Drupal.webform.detailsToggle.isFormDetailsOpen($form);var label=(isOpen)?Drupal.t('Collapse all'):Drupal.t('Expand all');$form.find('.webform-details-toggle-state').html(label);var text=(isOpen)?Drupal.t('All details have been expanded.'):Drupal.t('All details have been collapsed.');Drupal.announce(text);};})(jQuery,Drupal,once);;
(function($,Drupal,once){'use strict';var hasLocalStorage=(function(){try{localStorage.setItem('webform','webform');localStorage.removeItem('webform');return true;}catch(e){return false;}}());var hasSessionStorage=(function(){try{sessionStorage.setItem('webform','webform');sessionStorage.removeItem('webform');return true;}catch(e){return false;}}());Drupal.behaviors.webformMessageClose={attach:function(context){$(once('webform-message--close','.js-webform-message--close',context)).each(function(){var $element=$(this);var id=$element.attr('data-message-id');var storage=$element.attr('data-message-storage');var effect=$element.attr('data-message-close-effect')||'hide';switch(effect){case 'slide':effect='slideUp';break;case 'fade':effect='fadeOut';break;}if(isClosed($element,storage,id))return;if($element.attr('style')!=='display: none;'&&!$element.hasClass('js-webform-states-hidden'))$element.show();$element.find('.js-webform-message__link').on('click',function(event){$element[effect]();setClosed($element,storage,id);$element.trigger('close');event.preventDefault();});});}};function isClosed($element,storage,id){if(!id||!storage)return false;switch(storage){case 'local':if(hasLocalStorage)return localStorage.getItem('Drupal.webform.message.'+id)||false;return false;case 'session':if(hasSessionStorage)return sessionStorage.getItem('Drupal.webform.message.'+id)||false;return false;default:return false;}}function setClosed($element,storage,id){if(!id||!storage)return;switch(storage){case 'local':if(hasLocalStorage)localStorage.setItem('Drupal.webform.message.'+id,true);break;case 'session':if(hasSessionStorage)sessionStorage.setItem('Drupal.webform.message.'+id,true);break;case 'user':case 'state':case 'custom':$.get($element.find('.js-webform-message__link').attr('href'));return true;}}})(jQuery,Drupal,once);;
(function($,Drupal){'use strict';var isChrome=(/chrom(e|ium)/.test(window.navigator.userAgent.toLowerCase()));if(isChrome){var backButton=false;if(window.performance){var navEntries=window.performance.getEntriesByType('navigation');if(navEntries.length>0&&navEntries[0].type==='back_forward')backButton=true;else{if(window.performance.navigation&&window.performance.navigation.type===window.performance.navigation.TYPE_BACK_FORWARD)backButton=true;}}if(backButton){var attachBehaviors=Drupal.attachBehaviors;Drupal.attachBehaviors=function(context,settings){setTimeout(function(){attachBehaviors(context,settings);},300);};}}})(jQuery,Drupal);;
(function($,Drupal){const states={postponed:[]};Drupal.states=states;function invert(a,invertState){return invertState&&typeof a!=='undefined'?!a:a;}function compare(a,b){if(a===b)return typeof a==='undefined'?a:true;return typeof a==='undefined'||typeof b==='undefined';}function ternary(a,b){if(typeof a==='undefined')return b;if(typeof b==='undefined')return a;return a&&b;}Drupal.behaviors.states={attach(context,settings){const elements=once('states','[data-drupal-states]',context);const il=elements.length;for(let i=0;i<il;i++){const config=JSON.parse(elements[i].getAttribute('data-drupal-states'));Object.keys(config||{}).forEach((state)=>{new states.Dependent({element:$(elements[i]),state:states.State.sanitize(state),constraints:config[state]});});}while(states.postponed.length)states.postponed.shift()();}};states.Dependent=function(args){$.extend(this,{values:{},oldValue:null},args);this.dependees=this.getDependees();Object.keys(this.dependees||{}).forEach((selector)=>{this.initializeDependee(selector,this.dependees[selector]);});};states.Dependent.comparisons={RegExp(reference,value){return reference.test(value);},Function(reference,value){return reference(value);},Array(reference,value){if(!Array.isArray(value))return false;return JSON.stringify(reference.sort())===JSON.stringify(value.sort());},Number(reference,value){return typeof value==='string'?compare(reference.toString(),value):compare(reference,value);}};states.Dependent.prototype={initializeDependee(selector,dependeeStates){this.values[selector]={};Object.keys(dependeeStates).forEach((i)=>{let state=dependeeStates[i];if($.inArray(state,dependeeStates)===-1)return;state=states.State.sanitize(state);this.values[selector][state.name]=null;$(selector).on(`state:${state}`,{selector,state},(e)=>{this.update(e.data.selector,e.data.state,e.value);});new states.Trigger({selector,state});});},compare(reference,selector,state){const value=this.values[selector][state.name];if(reference.constructor.name in states.Dependent.comparisons)return states.Dependent.comparisons[reference.constructor.name](reference,value);return compare(reference,value);},update(selector,state,value){if(value!==this.values[selector][state.name]){this.values[selector][state.name]=value;this.reevaluate();}},reevaluate(){let value=this.verifyConstraints(this.constraints);if(value!==this.oldValue){this.oldValue=value;value=invert(value,this.state.invert);this.element.trigger({type:`state:${this.state}`,value,trigger:true});}},verifyConstraints(constraints,selector){let result;if(Array.isArray(constraints)){const hasXor=$.inArray('xor',constraints)===-1;const len=constraints.length;for(let i=0;i<len;i++)if(constraints[i]!=='xor'){const constraint=this.checkConstraints(constraints[i],selector,i);if(constraint&&(hasXor||result))return hasXor;result=result||constraint;}}else{if($.isPlainObject(constraints)){for(const n in constraints)if(constraints.hasOwnProperty(n)){result=ternary(result,this.checkConstraints(constraints[n],selector,n));if(result===false)return false;}}}return result;},checkConstraints(value,selector,state){if(typeof state!=='string'||/[0-9]/.test(state[0]))state=null;else{if(typeof selector==='undefined'){selector=state;state=null;}}if(state!==null){state=states.State.sanitize(state);return invert(this.compare(value,selector,state),state.invert);}return this.verifyConstraints(value,selector);},getDependees(){const cache={};const _compare=this.compare;this.compare=function(reference,selector,state){(cache[selector]||(cache[selector]=[])).push(state.name);};this.verifyConstraints(this.constraints);this.compare=_compare;return cache;}};states.Trigger=function(args){$.extend(this,args);if(this.state in states.Trigger.states){this.element=$(this.selector);if(!this.element.data(`trigger:${this.state}`))this.initialize();}};states.Trigger.prototype={initialize(){const trigger=states.Trigger.states[this.state];if(typeof trigger==='function')trigger.call(window,this.element);else Object.keys(trigger||{}).forEach((event)=>{this.defaultTrigger(event,trigger[event]);});this.element.data(`trigger:${this.state}`,true);},defaultTrigger(event,valueFn){let oldValue=valueFn.call(this.element);this.element.on(event,function(e){const value=valueFn.call(this.element,e);if(oldValue!==value){this.element.trigger({type:`state:${this.state}`,value,oldValue});oldValue=value;}}.bind(this));states.postponed.push(function(){this.element.trigger({type:`state:${this.state}`,value:oldValue,oldValue:null});}.bind(this));}};states.Trigger.states={empty:{keyup(){return this.val()==='';},change(){return this.val()==='';}},checked:{change(){let checked=false;this.each(function(){checked=$(this).prop('checked');return !checked;});return checked;}},value:{keyup(){if(this.length>1)return this.filter(':checked').val()||false;return this.val();},change(){if(this.length>1)return this.filter(':checked').val()||false;return this.val();}},collapsed:{collapsed(e){return typeof e!=='undefined'&&'value' in e?e.value:!this[0].hasAttribute('open');}}};states.State=function(state){this.pristine=state;this.name=state;let process=true;do{while(this.name.charAt(0)==='!'){this.name=this.name.substring(1);this.invert=!this.invert;}if(this.name in states.State.aliases)this.name=states.State.aliases[this.name];else process=false;}while(process);};states.State.sanitize=function(state){if(state instanceof states.State)return state;return new states.State(state);};states.State.aliases={enabled:'!disabled',invisible:'!visible',invalid:'!valid',untouched:'!touched',optional:'!required',filled:'!empty',unchecked:'!checked',irrelevant:'!relevant',expanded:'!collapsed',open:'!collapsed',closed:'collapsed',readwrite:'!readonly'};states.State.prototype={invert:false,toString(){return this.name;}};const $document=$(document);$document.on('state:disabled',(e)=>{const tagsSupportDisable='button, fieldset, optgroup, option, select, textarea, input';if(e.trigger)$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper').toggleClass('form-disabled',e.value).find(tagsSupportDisable).addBack(tagsSupportDisable).prop('disabled',e.value);});$document.on('state:readonly',(e)=>{if(e.trigger)$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper').toggleClass('form-readonly',e.value).find('input, textarea').prop('readonly',e.value);});$document.on('state:required',(e)=>{if(e.trigger)if(e.value){const label=`label${e.target.id?`[for=${e.target.id}]`:''}`;const $label=$(e.target).attr({required:'required','aria-required':'true'}).closest('.js-form-item, .js-form-wrapper').find(label);if(!$label.hasClass('js-form-required').length)$label.addClass('js-form-required form-required');}else $(e.target).removeAttr('required aria-required').closest('.js-form-item, .js-form-wrapper').find('label.js-form-required').removeClass('js-form-required form-required');});$document.on('state:visible',(e)=>{if(e.trigger){let $element=$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper');if(e.target.tagName==='A')$element=$(e.target);$element.toggle(e.value);}});$document.on('state:checked',(e)=>{if(e.trigger)$(e.target).closest('.js-form-item, .js-form-wrapper').find('input').prop('checked',e.value).trigger('change');});$document.on('state:collapsed',(e)=>{if(e.trigger)if(e.target.hasAttribute('open')===e.value)$(e.target).find('> summary').trigger('click');});})(jQuery,Drupal);;
(function($,Drupal,once){'use strict';Drupal.webform=Drupal.webform||{};Drupal.webform.states=Drupal.webform.states||{};Drupal.webform.states.slideDown=Drupal.webform.states.slideDown||{};Drupal.webform.states.slideDown.duration='slow';Drupal.webform.states.slideUp=Drupal.webform.states.slideUp||{};Drupal.webform.states.slideUp.duration='fast';$.fn.hasData=function(data){return (typeof this.data(data)!=='undefined');};$.fn.isWebform=function(){return $(this).closest('form.webform-submission-form, form[id^="webform"], form[data-is-webform]').length?true:false;};$.fn.isWebformElement=function(){return ($(this).isWebform()||$(this).closest('[data-is-webform-element]').length)?true:false;};Drupal.states.Trigger.states.empty.change=function change(){return this.val()==='';};var states=Drupal.states;Drupal.states.Dependent.prototype.compare=function compare(reference,selector,state){var value=this.values[selector][state.name];var name=reference.constructor.name;if(!name){name=$.type(reference);name=name.charAt(0).toUpperCase()+name.slice(1);}if(name in states.Dependent.comparisons)return states.Dependent.comparisons[name](reference,value);if(reference.constructor.name in states.Dependent.comparisons)return states.Dependent.comparisons[reference.constructor.name](reference,value);return _compare2(reference,value);};function _compare2(a,b){if(a===b)return typeof a==='undefined'?a:true;return typeof a==='undefined'||typeof b==='undefined';}Drupal.states.Dependent.comparisons.Object=function(reference,value){if('pattern' in reference)return (new RegExp(reference['pattern'])).test(value);else if('!pattern' in reference)return !((new RegExp(reference['!pattern'])).test(value));else if('less' in reference)return (value!==''&&parseFloat(reference['less'])>parseFloat(value));else if('less_equal' in reference)return (value!==''&&parseFloat(reference['less_equal'])>=parseFloat(value));else if('greater' in reference)return (value!==''&&parseFloat(reference['greater'])<parseFloat(value));else if('greater_equal' in reference)return (value!==''&&parseFloat(reference['greater_equal'])<=parseFloat(value));else if('between' in reference||'!between' in reference){if(value==='')return false;var between=reference['between']||reference['!between'];var betweenParts=between.split(':');var greater=betweenParts[0];var less=(typeof betweenParts[1]!=='undefined')?betweenParts[1]:null;var isGreaterThan=(greater===null||greater===''||parseFloat(value)>=parseFloat(greater));var isLessThan=(less===null||less===''||parseFloat(value)<=parseFloat(less));var result=(isGreaterThan&&isLessThan);return (reference['!between'])?!result:result;}else return reference.indexOf(value)!==false;};var $document=$(document);$document.on('state:required',function(e){if(e.trigger&&$(e.target).isWebformElement()){var $target=$(e.target);toggleRequired($target.find('input[type="file"]'),e.value);if($target.is('.js-form-type-radios, .js-form-type-webform-radios-other, .js-webform-type-radios, .js-webform-type-webform-radios-other, .js-webform-type-webform-entity-radios, .webform-likert-table')){$target.toggleClass('required',e.value);toggleRequired($target.find('input[type="radio"]'),e.value);}if($target.is('.js-form-type-checkboxes, .js-form-type-webform-checkboxes-other, .js-webform-type-checkboxes, .js-webform-type-webform-checkboxes-other')){$target.toggleClass('required',e.value);var $checkboxes=$target.find('input[type="checkbox"]');if(e.value){$checkboxes.on('click',statesCheckboxesRequiredEventHandler);checkboxesRequired($target);}else{$checkboxes.off('click',statesCheckboxesRequiredEventHandler);toggleRequired($checkboxes,false);}}if($target.is('.js-webform-tableselect')){$target.toggleClass('required',e.value);var isMultiple=$target.is('[multiple]');if(isMultiple){var $tbody=$target.find('tbody');var $checkboxes=$tbody.find('input[type="checkbox"]');copyRequireMessage($target,$checkboxes);if(e.value){$checkboxes.on('click change',statesCheckboxesRequiredEventHandler);checkboxesRequired($tbody);}else{$checkboxes.off('click change ',statesCheckboxesRequiredEventHandler);toggleRequired($tbody,false);}}else{var $radios=$target.find('input[type="radio"]');copyRequireMessage($target,$radios);toggleRequired($radios,e.value);}}if($target.is('.js-form-type-webform-select-other, .js-webform-type-webform-select-other')){var $select=$target.find('select');toggleRequired($select,e.value);copyRequireMessage($target,$select);}if($target.find('> label:not([for])').length)$target.find('> label').toggleClass('js-form-required form-required',e.value);if($target.is('.js-webform-type-radios, .js-webform-type-checkboxes, fieldset'))$target.find('legend span.fieldset-legend:not(.visually-hidden),legend span.fieldset__label:not(.visually-hidden)').toggleClass('js-form-required form-required',e.value);if($target.is('fieldset'))$target.removeAttr('required aria-required');}});$document.on('state:checked',function(e){if(e.trigger)$(e.target).trigger('change');});$document.on('state:readonly',function(e){if(e.trigger&&$(e.target).isWebformElement()){$(e.target).prop('readonly',e.value).closest('.js-form-item, .js-form-wrapper').toggleClass('webform-readonly',e.value).find('input, textarea').prop('readonly',e.value);$(e.target).trigger('webform:readonly').find('select, input, textarea, button').trigger('webform:readonly');}});$document.on('state:visible state:visible-slide',function(e){if(e.trigger&&$(e.target).isWebformElement())if(e.value)$(':input',e.target).addBack().each(function(){restoreValueAndRequired(this);triggerEventHandlers(this);});else $(':input',e.target).addBack().each(function(){backupValueAndRequired(this);clearValueAndRequired(this);triggerEventHandlers(this);});});$document.on('state:visible-slide',function(e){if(e.trigger&&$(e.target).isWebformElement()){var effect=e.value?'slideDown':'slideUp';var duration=Drupal.webform.states[effect].duration;$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper')[effect](duration);}});Drupal.states.State.aliases['invisible-slide']='!visible-slide';$document.on('state:disabled',function(e){if(e.trigger&&$(e.target).isWebformElement()){$(e.target).prop('disabled',e.value).closest('.js-form-item, .js-form-submit, .js-form-wrapper').toggleClass('form-disabled',e.value).find('select, input, textarea, button').prop('disabled',e.value);var fileElements=$(e.target).find(':input[type="hidden"][name$="[fids]"]');if(fileElements.length){if($(e.target).is('fieldset'))$(e.target).prop('disabled',false);fileElements.removeAttr('disabled');}$(e.target).trigger('webform:disabled').find('select, input, textarea, button').trigger('webform:disabled');}});Drupal.behaviors.webformCheckboxesRequired={attach:function(context){$(once('webform-checkboxes-required','.js-form-type-checkboxes.required, .webform-term-checkboxes.required, .js-form-type-webform-checkboxes-other.required, .js-webform-type-checkboxes.required, .js-webform-type-webform-checkboxes-other.required, .js-webform-type-webform-radios-other.checkboxes',context)).each(function(){var $element=$(this);$element.find('input[type="checkbox"]').on('click',statesCheckboxesRequiredEventHandler);setTimeout(function(){checkboxesRequired($element);});});}};Drupal.behaviors.webformRadiosRequired={attach:function(context){$(once('webform-radios-required','.js-form-type-radios, .js-form-type-webform-radios-other, .js-webform-type-radios, .js-webform-type-webform-radios-other, .js-webform-type-webform-entity-radios, .js-webform-type-webform-scale',context)).each(function(){var $element=$(this);setTimeout(function(){radiosRequired($element);});});}};Drupal.behaviors.webformTableSelectRequired={attach:function(context){$(once('webform-tableselect-required','.js-webform-tableselect.required',context)).each(function(){var $element=$(this);var $tbody=$element.find('tbody');var isMultiple=$element.is('[multiple]');if(isMultiple)$tbody.find('input[type="checkbox"]').on('click change',function(){checkboxesRequired($tbody);});setTimeout(function(){isMultiple?checkboxesRequired($tbody):radiosRequired($element);});});}};function checkboxesRequired($element){var $firstCheckbox=$element.find('input[type="checkbox"]').first();var isChecked=$element.find('input[type="checkbox"]').is(':checked');toggleRequired($firstCheckbox,!isChecked);copyRequireMessage($element,$firstCheckbox);}function radiosRequired($element){var $radios=$element.find('input[type="radio"]');var isRequired=$element.hasClass('required');toggleRequired($radios,isRequired);copyRequireMessage($element,$radios);}function statesCheckboxesRequiredEventHandler(){var $element=$(this).closest('.js-webform-type-checkboxes, .js-webform-type-webform-checkboxes-other, .js-webform-type-webform-term-checkboxes, .js-webform-tableselect tbody');checkboxesRequired($element);}function triggerEventHandlers(input){var $input=$(input);var type=input.type;var tag=input.tagName.toLowerCase();var extraParameters=['webform.states'];if(type==='checkbox'||type==='radio')$input.trigger('change',extraParameters).trigger('blur',extraParameters);else if(tag==='select'){if($input.closest('.webform-type-address').length){if(!$input.data('webform-states-address-initialized')&&$input.attr('autocomplete')==='country'&&$input.val()===$input.find("option[selected]").attr('value'))return;$input.data('webform-states-address-initialized',true);}$input.trigger('change',extraParameters).trigger('blur',extraParameters);}else{if(type!=='submit'&&type!=='button'&&type!=='file'){var hasInputMask=($.fn.inputmask&&$input.hasClass('js-webform-input-mask'));hasInputMask&&$input.inputmask('remove');$input.trigger('input',extraParameters).trigger('change',extraParameters).trigger('keydown',extraParameters).trigger('keyup',extraParameters).trigger('blur',extraParameters);hasInputMask&&$input.inputmask();}}}function backupValueAndRequired(input){var $input=$(input);var type=input.type;var tag=input.tagName.toLowerCase();if($input.prop('required')&&!$input.hasData('webform-required'))$input.data('webform-required',true);if(!$input.hasData('webform-value'))if(type==='checkbox'||type==='radio')$input.data('webform-value',$input.prop('checked'));else if(tag==='select'){var values=[];$input.find('option:selected').each(function(i,option){values[i]=option.value;});$input.data('webform-value',values);}else{if(type!=='submit'&&type!=='button')$input.data('webform-value',input.value);}}function restoreValueAndRequired(input){var $input=$(input);var value=$input.data('webform-value');if(typeof value!=='undefined'){var type=input.type;var tag=input.tagName.toLowerCase();if(type==='checkbox'||type==='radio')$input.prop('checked',value);else if(tag==='select')$.each(value,function(i,option_value){option_value=option_value.replace(/'/g,"\\\'");$input.find("option[value='"+option_value+"']").prop('selected',true);});else{if(type!=='submit'&&type!=='button')input.value=value;}$input.removeData('webform-value');}var required=$input.data('webform-required');if(typeof required!=='undefined'){if(required)$input.prop('required',true);$input.removeData('webform-required');}}function clearValueAndRequired(input){var $input=$(input);if($input.closest('[data-webform-states-no-clear]').length)return;var type=input.type;var tag=input.tagName.toLowerCase();if(type==='checkbox'||type==='radio')$input.prop('checked',false);else if(tag==='select')if($input.find('option[value=""]').length)$input.val('');else input.selectedIndex=-1;else{if(type!=='submit'&&type!=='button')input.value=(type==='color')?'#000000':'';}$input.prop('required',false);}function toggleRequired($input,required){var isCheckboxOrRadio=($input.attr('type')==='radio'||$input.attr('type')==='checkbox');if(required)if(isCheckboxOrRadio)$input.attr({'required':'required'});else $input.attr({'required':'required','aria-required':'true'});else{if(isCheckboxOrRadio)$input.removeAttr('required');else $input.removeAttr('required aria-required');$input.each(function(){this.setCustomValidity&&this.setCustomValidity('');});}}function copyRequireMessage($source,$destination){if($source.attr('data-msg-required'))$destination.attr('data-msg-required',$source.attr('data-msg-required'));}})(jQuery,Drupal,once);;
(function($,Drupal,once){'use strict';Drupal.behaviors.webformRemoveFormSingleSubmit={attach:function attach(){function onFormSubmit(e){var $form=$(e.currentTarget);$form.removeAttr('data-drupal-form-submit-last');}$(once('webform-single-submit','body')).on('submit.singleSubmit','form.webform-remove-single-submit',onFormSubmit);}};Drupal.behaviors.webformDisableAutoSubmit={attach:function(context){$(once('webform-disable-autosubmit',$('.js-webform-disable-autosubmit input').not(':button, :submit, :reset, :image, :file'))).on('keyup keypress',function(e){if(e.which===13){e.preventDefault();return false;}});}};Drupal.behaviors.webformRequiredError={attach:function(context){$(once('webform-required-error',$(context).find(':input[data-webform-required-error], :input[data-webform-pattern-error]'))).on('invalid',function(){this.setCustomValidity('');if(this.valid)return;if(this.validity.patternMismatch&&$(this).attr('data-webform-pattern-error'))this.setCustomValidity($(this).attr('data-webform-pattern-error'));else{if(this.validity.valueMissing&&$(this).attr('data-webform-required-error'))this.setCustomValidity($(this).attr('data-webform-required-error'));}}).on('input change',function(){var name=$(this).attr('name');$(this.form).find(':input[name="'+name+'"]').each(function(){this.setCustomValidity('');});});}};$(document).on('state:required',function(e){$(e.target).filter(':input[data-webform-required-error]').each(function(){this.setCustomValidity('');});});})(jQuery,Drupal,once);;
