<?php

namespace Drupal\divihn_bootstrap\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides a 'What We Do' Block.
 *
 * @Block(
 *   id = "what_we_do_block",
 *   admin_label = @Translation("What We Do Block")
 * )
 */
class WhatWeDoBlock extends BlockBase {
  /**
   * {@inheritdoc}
   */
  public function build() {
    return [
      '#theme' => 'what_we_do',
      '#section_title' => 'Accelerate Your Growth With Us',
      '#description' => 'Transformation is a journey...',
      '#services' => [
        [
          'title' => 'Digitalization',
          'description' => 'We design digital transformation...',
          'icon' => drupal_get_path('theme', 'divihn_bootstrap') . '/images/digitalization.svg',
          'link' => '/digitalization',
        ],
        [
          'title' => 'Business Tech',
          'description' => 'We deliver technology solutions...',
          'icon' => drupal_get_path('theme', 'divihn_bootstrap') . '/images/business-tech.svg',
          'link' => '/business-tech',
        ],
      ],
      '#specialisations' => [
        [
          'title' => 'Enterprise Architecture',
          'description' => 'Content for EA...',
          'icon' => drupal_get_path('theme', 'divihn_bootstrap') . '/images/ea.svg',
          'link' => '/enterprise-architecture',
        ],
        [
          'title' => 'Salesforce',
          'description' => 'Content for Salesforce...',
          'icon' => drupal_get_path('theme', 'divihn_bootstrap') . '/images/salesforce.svg',
          'link' => '/salesforce',
        ],
      ],
      '#attached' => [
        'library' => [
          'divihn_bootstrap/whatwedo',
        ],
      ],
    ];
  }
}
