# The Better Mega Menu

TB Mega Menu provides a drag and drop interface for creating drop down menus
that combine Drupal menu items with rich media content. Your menu can include
internal and external links, images, videos and anything else that can appear
in a Drupal block.


## Table of contents

- Features
- Requirements
- Installation
- Configuration
- Maintainers


## Features

- Synchronizes with Drupal core menus
- Allows Drupal blocks to be added to the menu
- Drag and drop administrative interface
- Accessibility features for keyboard navigation and screen readers
- Custom styling available for menu items
- Multiple built-in CSS3 animation effects
- Responsive ready


## Requirements

- This module requires no modules outside of Drupal core.
- Optionally, the chosen library can be installed to enhance the appearance of
  select dropdowns in the admin interface.
  See https://www.drupal.org/project/chosen for installation instructions.


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

- Navigate to Extend and enable the TB Mega Menu module.
- Navigate to Structure -> TB Mega Menu to create a new menu.


## Maintainers

- Wade Stewart - [themodularlab](https://www.drupal.org/u/themodularlab)
- Andy Olson - [andrewozone](https://www.drupal.org/u/andrewozone)
- Michael Girgis - [knaffles](https://www.drupal.org/u/knaffles)
- This module is currently owned and maintained by
  Bounteous - [Bounteous](https://www.bounteous.com)
- This module was originally developed by ThemeBrain.


## CHANGELOG

- Follows Keep a Changelog as a guide for managing and
maintaining changelog.
-   - see https://keepachangelog.com/en/1.0.0/
- Changelog managed as markdown (.md) file.
- Convert to HTML for Drupal Release Notes.
    - See https://markdowntohtml.com/
- Changle log Structure:
    - Unreleased (dev branch).
    - Releases (version & date, categorized by type)
- Date format: YEAR-Month-Day or YYYY-MM-DD
- Everything else is Release notes, organized by type of change
    - **Added** for new features.
    - **Changed** for changes in existing functionality.
    - **Deprecated** for soon-to-be removed features.
    - **Removed** for now removed features.
    - **Fixed** for any bug fixes.
    - **Security** in case of vulnerabilities.
- Other Guides:
    - Changelogs are for humans, not machines.
    - There should be an entry for every single version.
    - The same types of changes should be grouped.
    - Versions and sections should be linkable.
    - The latest version comes first.
    - The release date of each version is displayed.
Mention whether you follow Semantic Versioning.
